/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json;

import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.flink.table.store.shaded.org.apache.thrift.TException;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONAlterPartitionMessage
extends AlterPartitionMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    String isTruncateOp;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    Map<String, String> keyValues;
    @JsonProperty
    String partitionObjBeforeJson;
    @JsonProperty
    String partitionObjAfterJson;

    public JSONAlterPartitionMessage() {
    }

    public JSONAlterPartitionMessage(String server, String servicePrincipal, Table tableObj, Partition partitionObjBefore, Partition partitionObjAfter, boolean isTruncateOp, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = tableObj.getDbName();
        this.table = tableObj.getTableName();
        this.tableType = tableObj.getTableType();
        this.isTruncateOp = Boolean.toString(isTruncateOp);
        this.timestamp = timestamp;
        this.keyValues = JSONMessageFactory.getPartitionKeyValues(tableObj, partitionObjBefore);
        try {
            this.tableObjJson = JSONMessageFactory.createTableObjJson(tableObj);
            this.partitionObjBeforeJson = JSONMessageFactory.createPartitionObjJson(partitionObjBefore);
            this.partitionObjAfterJson = JSONMessageFactory.createPartitionObjJson(partitionObjAfter);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        if (this.tableType != null) {
            return this.tableType;
        }
        return "";
    }

    @Override
    public boolean getIsTruncateOp() {
        return Boolean.parseBoolean(this.isTruncateOp);
    }

    @Override
    public Map<String, String> getKeyValues() {
        return this.keyValues;
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)JSONMessageFactory.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Partition getPtnObjBefore() throws Exception {
        return (Partition)JSONMessageFactory.getTObj(this.partitionObjBeforeJson, Partition.class);
    }

    @Override
    public Partition getPtnObjAfter() throws Exception {
        return (Partition)JSONMessageFactory.getTObj(this.partitionObjAfterJson, Partition.class);
    }

    public String getTableObjJson() {
        return this.tableObjJson;
    }

    public String getPartitionObjBeforeJson() {
        return this.partitionObjBeforeJson;
    }

    public String getPartitionObjAfterJson() {
        return this.partitionObjAfterJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }
}

