/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.datasource;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoneCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BoneCPDataSourceProvider.class);
    public static final String BONECP = "bonecp";
    private static final String CONNECTION_TIMEOUT_PROPERTY = "bonecp.connectionTimeoutInMs";
    private static final String PARTITION_COUNT_PROPERTY = "bonecp.partitionCount";

    @Override
    public DataSource create(Configuration hdpConfig) throws SQLException {
        LOG.debug("Creating BoneCP connection pool for the MetaStore");
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        int maxPoolSize = MetastoreConf.getIntVar(hdpConfig, MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
        Properties properties = DataSourceProvider.getPrefixedProperties(hdpConfig, BONECP);
        long connectionTimeout = hdpConfig.getLong(CONNECTION_TIMEOUT_PROPERTY, 30000L);
        String partitionCount = properties.getProperty(PARTITION_COUNT_PROPERTY, "1");
        BoneCPConfig config = null;
        try {
            config = new BoneCPConfig(properties);
        }
        catch (Exception e) {
            throw new SQLException("Cannot create BoneCP configuration: ", e);
        }
        config.setJdbcUrl(driverUrl);
        config.setConnectionTimeoutInMs(connectionTimeout);
        config.setMaxConnectionsPerPartition(maxPoolSize);
        config.setPartitionCount(Integer.parseInt(partitionCount));
        config.setUser(user);
        config.setPassword(passwd);
        return new BoneCPDataSource(config);
    }

    @Override
    public boolean mayReturnClosedConnection() {
        return true;
    }

    @Override
    public boolean supports(Configuration configuration) {
        String poolingType = MetastoreConf.getVar(configuration, MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE).toLowerCase();
        if (BONECP.equals(poolingType)) {
            int boneCpPropsNr = DataSourceProvider.getPrefixedProperties(configuration, BONECP).size();
            LOG.debug("Found " + boneCpPropsNr + " nr. of bonecp specific configurations");
            return boneCpPropsNr > 0;
        }
        LOG.debug("Configuration requested " + poolingType + " pooling, BoneCpDSProvider exiting");
        return false;
    }
}

