/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.thrift.TException;

public class CatalogBuilder {
    private String name;
    private String description;
    private String location;

    public CatalogBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public CatalogBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public CatalogBuilder setLocation(String location) {
        this.location = location;
        return this;
    }

    public Catalog build() throws MetaException {
        if (this.name == null) {
            throw new MetaException("You must name the catalog");
        }
        if (this.location == null) {
            throw new MetaException("You must give the catalog a location");
        }
        Catalog catalog = new Catalog(this.name, this.location);
        if (this.description != null) {
            catalog.setDescription(this.description);
        }
        return catalog;
    }

    public Catalog create(IMetaStoreClient client) throws TException {
        Catalog cat = this.build();
        client.createCatalog(cat);
        return cat;
    }
}

