/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.Serializable;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.sink.Committable;
import org.apache.flink.table.store.connector.sink.CommittableStateManager;
import org.apache.flink.table.store.connector.sink.Committer;
import org.apache.flink.table.store.connector.sink.FlinkSink;
import org.apache.flink.table.store.connector.sink.NoopCommittableStateManager;
import org.apache.flink.table.store.connector.sink.StoreCommitter;
import org.apache.flink.table.store.connector.sink.StoreCompactOperator;
import org.apache.flink.table.store.connector.sink.StoreSinkWrite;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.util.function.SerializableFunction;

public class CompactorSink
extends FlinkSink {
    private static final long serialVersionUID = 1L;
    private final Lock.Factory lockFactory;

    public CompactorSink(FileStoreTable table, Lock.Factory lockFactory) {
        super(table, false);
        this.lockFactory = lockFactory;
    }

    @Override
    protected OneInputStreamOperator<RowData, Committable> createWriteOperator(StoreSinkWrite.Provider writeProvider, boolean isStreaming) {
        return new StoreCompactOperator(this.table, writeProvider, isStreaming);
    }

    @Override
    protected SerializableFunction<String, Committer> createCommitterFactory(boolean streamingCheckpointEnabled) {
        return (SerializableFunction & Serializable)user -> new StoreCommitter(this.table.newCommit((String)user).withLock(this.lockFactory.create()));
    }

    @Override
    protected CommittableStateManager createCommittableStateManager() {
        return new NoopCommittableStateManager();
    }
}

