/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class CreatePartitionsRequestData
implements ApiMessage {
    CreatePartitionsTopicCollection topics;
    int timeoutMs;
    boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public CreatePartitionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreatePartitionsRequestData() {
        this.topics = new CreatePartitionsTopicCollection(0);
        this.timeoutMs = 0;
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 37;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        CreatePartitionsTopicCollection newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatePartitionsTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatePartitionsTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatePartitionsTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatePartitionsTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (CreatePartitionsTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (CreatePartitionsTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (CreatePartitionsTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(4);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreatePartitionsRequestData)) {
            return false;
        }
        CreatePartitionsRequestData other = (CreatePartitionsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public CreatePartitionsRequestData duplicate() {
        CreatePartitionsRequestData _duplicate = new CreatePartitionsRequestData();
        CreatePartitionsTopicCollection newTopics = new CreatePartitionsTopicCollection(this.topics.size());
        for (CreatePartitionsTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        _duplicate.validateOnly = this.validateOnly;
        return _duplicate;
    }

    public String toString() {
        return "CreatePartitionsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public CreatePartitionsTopicCollection topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreatePartitionsRequestData setTopics(CreatePartitionsTopicCollection v) {
        this.topics = v;
        return this;
    }

    public CreatePartitionsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreatePartitionsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatePartitionsTopic.SCHEMA_0), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."));
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("topics", new CompactArrayOf(CreatePartitionsTopic.SCHEMA_2), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class CreatePartitionsTopicCollection
    extends ImplicitLinkedHashMultiCollection<CreatePartitionsTopic> {
        public CreatePartitionsTopicCollection() {
        }

        public CreatePartitionsTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatePartitionsTopicCollection(Iterator<CreatePartitionsTopic> iterator) {
            super(iterator);
        }

        @Override
        public CreatePartitionsTopic find(String name) {
            CreatePartitionsTopic _key = new CreatePartitionsTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<CreatePartitionsTopic> findAll(String name) {
            CreatePartitionsTopic _key = new CreatePartitionsTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreatePartitionsTopicCollection duplicate() {
            CreatePartitionsTopicCollection _duplicate = new CreatePartitionsTopicCollection(this.size());
            for (CreatePartitionsTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreatePartitionsAssignment
    implements Message {
        List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public CreatePartitionsAssignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatePartitionsAssignment() {
            this.brokerIds = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
            } else {
                _writable.writeInt(this.brokerIds.size());
            }
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsAssignment");
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsAssignment)) {
                return false;
            }
            CreatePartitionsAssignment other = (CreatePartitionsAssignment)obj;
            if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
            return hashCode;
        }

        @Override
        public CreatePartitionsAssignment duplicate() {
            CreatePartitionsAssignment _duplicate = new CreatePartitionsAssignment();
            ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
            for (Integer _element : this.brokerIds) {
                newBrokerIds.add(_element);
            }
            _duplicate.brokerIds = newBrokerIds;
            return _duplicate;
        }

        public String toString() {
            return "CreatePartitionsAssignment(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_ids", new ArrayOf(Type.INT32), "The assigned broker IDs."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The assigned broker IDs."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class CreatePartitionsTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        int count;
        List<CreatePartitionsAssignment> assignments;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public CreatePartitionsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatePartitionsTopic() {
            this.name = "";
            this.count = 0;
            this.assignments = new ArrayList<CreatePartitionsAssignment>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<CreatePartitionsAssignment> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.count = _readable.readInt();
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.assignments = null;
                } else {
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                    }
                    this.assignments = newCollection;
                }
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    this.assignments = null;
                } else {
                    newCollection = new ArrayList<CreatePartitionsAssignment>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                    }
                    this.assignments = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.count);
            if (_version >= 2) {
                if (this.assignments == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.assignments.size() + 1);
                    _stringBytes = this.assignments.iterator();
                    while (_stringBytes.hasNext()) {
                        CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                        assignmentsElement.write(_writable, _cache, _version);
                    }
                }
            } else if (this.assignments == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(4);
            if (this.assignments == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(4);
                }
            } else {
                if (_version >= 2) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.assignments.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                for (CreatePartitionsAssignment assignmentsElement : this.assignments) {
                    assignmentsElement.addSize(_size, _cache, _version);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            if (this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public CreatePartitionsTopic duplicate() {
            CreatePartitionsTopic _duplicate = new CreatePartitionsTopic();
            _duplicate.name = this.name;
            _duplicate.count = this.count;
            if (this.assignments == null) {
                _duplicate.assignments = null;
            } else {
                ArrayList<CreatePartitionsAssignment> newAssignments = new ArrayList<CreatePartitionsAssignment>(this.assignments.size());
                for (CreatePartitionsAssignment _element : this.assignments) {
                    newAssignments.add(_element.duplicate());
                }
                _duplicate.assignments = newAssignments;
            }
            return _duplicate;
        }

        public String toString() {
            return "CreatePartitionsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", count=" + this.count + ", assignments=" + (this.assignments == null ? "null" : MessageUtil.deepToString(this.assignments.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public int count() {
            return this.count;
        }

        public List<CreatePartitionsAssignment> assignments() {
            return this.assignments;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatePartitionsTopic setCount(int v) {
            this.count = v;
            return this;
        }

        public CreatePartitionsTopic setAssignments(List<CreatePartitionsAssignment> v) {
            this.assignments = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", ArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_0), "The new partition assignments."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", CompactArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_2), "The new partition assignments."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

