/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.feature;

import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.feature.BaseVersionRange;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.feature.SupportedVersionRange;

public class FinalizedVersionRange
extends BaseVersionRange {
    private static final String MIN_VERSION_LEVEL_KEY_LABEL = "min_version_level";
    private static final String MAX_VERSION_LEVEL_KEY_LABEL = "max_version_level";

    public FinalizedVersionRange(short minVersionLevel, short maxVersionLevel) {
        super(MIN_VERSION_LEVEL_KEY_LABEL, minVersionLevel, MAX_VERSION_LEVEL_KEY_LABEL, maxVersionLevel);
    }

    public static FinalizedVersionRange fromMap(Map<String, Short> versionRangeMap) {
        return new FinalizedVersionRange(BaseVersionRange.valueOrThrow(MIN_VERSION_LEVEL_KEY_LABEL, versionRangeMap), BaseVersionRange.valueOrThrow(MAX_VERSION_LEVEL_KEY_LABEL, versionRangeMap));
    }

    public boolean isIncompatibleWith(SupportedVersionRange supportedVersionRange) {
        return this.min() < supportedVersionRange.min() || this.max() > supportedVersionRange.max();
    }
}

