/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.util.Objects;
import org.apache.flink.table.store.file.schema.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;

public class ArrayDataType
extends DataType {
    private static final long serialVersionUID = 1L;
    private final DataType elementType;

    public ArrayDataType(boolean isNullable, DataType elementType) {
        super((LogicalType)new ArrayType(isNullable, elementType.logicalType));
        this.elementType = elementType;
    }

    public DataType elementType() {
        return this.elementType;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new ArrayDataType(isNullable, this.elementType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayDataType that = (ArrayDataType)o;
        return Objects.equals(this.elementType, that.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementType);
    }
}

