/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.crypto;

import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesCtrDecryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesCtrEncryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesGcmDecryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesGcmEncryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesMode;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BlockCipher;

public class ModuleCipherFactory {
    public static final int SIZE_LENGTH = 4;

    public static BlockCipher.Encryptor getEncryptor(AesMode mode, byte[] keyBytes) {
        switch (mode) {
            case GCM: {
                return new AesGcmEncryptor(keyBytes);
            }
            case CTR: {
                return new AesCtrEncryptor(keyBytes);
            }
        }
        throw new IllegalArgumentException("AesMode not supported in ModuleCipherFactory: " + (Object)((Object)mode));
    }

    public static BlockCipher.Decryptor getDecryptor(AesMode mode, byte[] keyBytes) {
        switch (mode) {
            case GCM: {
                return new AesGcmDecryptor(keyBytes);
            }
            case CTR: {
                return new AesCtrDecryptor(keyBytes);
            }
        }
        throw new IllegalArgumentException("AesMode not supported in ModuleCipherFactory: " + (Object)((Object)mode));
    }

    public static enum ModuleType {
        Footer(0),
        ColumnMetaData(1),
        DataPage(2),
        DictionaryPage(3),
        DataPageHeader(4),
        DictionaryPageHeader(5),
        ColumnIndex(6),
        OffsetIndex(7),
        BloomFilterHeader(8),
        BloomFilterBitset(9);

        private final byte value;

        private ModuleType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

