/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.kafka;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.table.store.utils.ProjectedRowData;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class KafkaLogDeserializationSchema
implements KafkaDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> producedType;
    private final int fieldCount;
    private final int[] primaryKey;
    @Nullable
    private final DeserializationSchema<RowData> primaryKeyDeserializer;
    private final DeserializationSchema<RowData> valueDeserializer;
    private final RowData.FieldGetter[] keyFieldGetters;
    @Nullable
    private final int[][] projectFields;
    private transient ProjectCollector projectCollector;

    public KafkaLogDeserializationSchema(DataType physicalType, int[] primaryKey, @Nullable DeserializationSchema<RowData> primaryKeyDeserializer, DeserializationSchema<RowData> valueDeserializer, @Nullable int[][] projectFields) {
        this.primaryKey = primaryKey;
        this.primaryKeyDeserializer = primaryKeyDeserializer;
        this.valueDeserializer = valueDeserializer;
        DataType projectedType = projectFields == null ? physicalType : Projection.of(projectFields).project(physicalType);
        this.producedType = InternalTypeInfo.of((LogicalType)projectedType.getLogicalType());
        this.fieldCount = physicalType.getChildren().size();
        this.projectFields = projectFields;
        this.keyFieldGetters = (RowData.FieldGetter[])IntStream.range(0, primaryKey.length).mapToObj(i -> RowDataUtils.createNullCheckingFieldGetter(((DataType)physicalType.getChildren().get(primaryKey[i])).getLogicalType(), i)).toArray(RowData.FieldGetter[]::new);
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        if (this.primaryKeyDeserializer != null) {
            this.primaryKeyDeserializer.open(context);
        }
        this.valueDeserializer.open(context);
        this.projectCollector = new ProjectCollector();
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public RowData deserialize(ConsumerRecord<byte[], byte[]> record) {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> record, Collector<RowData> underCollector) throws Exception {
        Collector collector = this.projectCollector.project((Collector<RowData>)underCollector);
        if (this.primaryKey.length > 0 && record.value() == null) {
            RowData key = (RowData)this.primaryKeyDeserializer.deserialize(record.key());
            GenericRowData value = new GenericRowData(RowKind.DELETE, this.fieldCount);
            for (int i = 0; i < this.primaryKey.length; ++i) {
                value.setField(this.primaryKey[i], this.keyFieldGetters[i].getFieldOrNull(key));
            }
            collector.collect((Object)value);
        } else {
            this.valueDeserializer.deserialize(record.value(), collector);
        }
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedType;
    }

    private class ProjectCollector
    implements Collector<RowData> {
        private final ProjectedRowData projectedRow;
        private Collector<RowData> underCollector;

        private ProjectCollector() {
            this.projectedRow = KafkaLogDeserializationSchema.this.projectFields == null ? null : ProjectedRowData.from(KafkaLogDeserializationSchema.this.projectFields);
        }

        private Collector<RowData> project(Collector<RowData> underCollector) {
            if (this.projectedRow == null) {
                return underCollector;
            }
            this.underCollector = underCollector;
            return this;
        }

        public void collect(RowData rowData) {
            this.underCollector.collect((Object)this.projectedRow.replaceRow(rowData));
        }

        public void close() {
        }
    }
}

