/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;

public class Snapshot {
    public static final long FIRST_SNAPSHOT_ID = 1L;
    private static final int TABLE_STORE_02_VERSION = 1;
    private static final int CURRENT_VERSION = 2;
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_ID = "id";
    private static final String FIELD_SCHEMA_ID = "schemaId";
    private static final String FIELD_BASE_MANIFEST_LIST = "baseManifestList";
    private static final String FIELD_DELTA_MANIFEST_LIST = "deltaManifestList";
    private static final String FIELD_CHANGELOG_MANIFEST_LIST = "changelogManifestList";
    private static final String FIELD_COMMIT_USER = "commitUser";
    private static final String FIELD_COMMIT_IDENTIFIER = "commitIdentifier";
    private static final String FIELD_COMMIT_KIND = "commitKind";
    private static final String FIELD_TIME_MILLIS = "timeMillis";
    private static final String FIELD_LOG_OFFSETS = "logOffsets";
    @JsonProperty(value="version")
    @Nullable
    private final Integer version;
    @JsonProperty(value="id")
    private final long id;
    @JsonProperty(value="schemaId")
    private final long schemaId;
    @JsonProperty(value="baseManifestList")
    private final String baseManifestList;
    @JsonProperty(value="deltaManifestList")
    private final String deltaManifestList;
    @JsonProperty(value="changelogManifestList")
    @Nullable
    private final String changelogManifestList;
    @JsonProperty(value="commitUser")
    private final String commitUser;
    @JsonProperty(value="commitIdentifier")
    private final long commitIdentifier;
    @JsonProperty(value="commitKind")
    private final CommitKind commitKind;
    @JsonProperty(value="timeMillis")
    private final long timeMillis;
    @JsonProperty(value="logOffsets")
    private final Map<Integer, Long> logOffsets;

    public Snapshot(long id, long schemaId, String baseManifestList, String deltaManifestList, @Nullable String changelogManifestList, String commitUser, long commitIdentifier, CommitKind commitKind, long timeMillis, Map<Integer, Long> logOffsets) {
        this(2, id, schemaId, baseManifestList, deltaManifestList, changelogManifestList, commitUser, commitIdentifier, commitKind, timeMillis, logOffsets);
    }

    @JsonCreator
    public Snapshot(@JsonProperty(value="version") @Nullable Integer version, @JsonProperty(value="id") long id, @JsonProperty(value="schemaId") long schemaId, @JsonProperty(value="baseManifestList") String baseManifestList, @JsonProperty(value="deltaManifestList") String deltaManifestList, @JsonProperty(value="changelogManifestList") @Nullable String changelogManifestList, @JsonProperty(value="commitUser") String commitUser, @JsonProperty(value="commitIdentifier") long commitIdentifier, @JsonProperty(value="commitKind") CommitKind commitKind, @JsonProperty(value="timeMillis") long timeMillis, @JsonProperty(value="logOffsets") Map<Integer, Long> logOffsets) {
        this.version = version;
        this.id = id;
        this.schemaId = schemaId;
        this.baseManifestList = baseManifestList;
        this.deltaManifestList = deltaManifestList;
        this.changelogManifestList = changelogManifestList;
        this.commitUser = commitUser;
        this.commitIdentifier = commitIdentifier;
        this.commitKind = commitKind;
        this.timeMillis = timeMillis;
        this.logOffsets = logOffsets;
    }

    @JsonGetter(value="version")
    public int version() {
        return this.version == null ? 1 : this.version;
    }

    @JsonGetter(value="id")
    public long id() {
        return this.id;
    }

    @JsonGetter(value="schemaId")
    public long schemaId() {
        return this.schemaId;
    }

    @JsonGetter(value="baseManifestList")
    public String baseManifestList() {
        return this.baseManifestList;
    }

    @JsonGetter(value="deltaManifestList")
    public String deltaManifestList() {
        return this.deltaManifestList;
    }

    @JsonGetter(value="changelogManifestList")
    @Nullable
    public String changelogManifestList() {
        return this.changelogManifestList;
    }

    @JsonGetter(value="commitUser")
    public String commitUser() {
        return this.commitUser;
    }

    @JsonGetter(value="commitIdentifier")
    public long commitIdentifier() {
        return this.commitIdentifier;
    }

    @JsonGetter(value="commitKind")
    public CommitKind commitKind() {
        return this.commitKind;
    }

    @JsonGetter(value="timeMillis")
    public long timeMillis() {
        return this.timeMillis;
    }

    @JsonGetter(value="logOffsets")
    public Map<Integer, Long> getLogOffsets() {
        return this.logOffsets;
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public List<ManifestFileMeta> readAllDataManifests(ManifestList manifestList) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(manifestList.read(this.baseManifestList));
        result.addAll(manifestList.read(this.deltaManifestList));
        return result;
    }

    public static Snapshot fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Snapshot.class);
    }

    public static Snapshot fromPath(Path path) {
        try {
            String json = FileUtils.readFileUtf8(path);
            return Snapshot.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to read snapshot from path " + path, e);
        }
    }

    public static enum CommitKind {
        APPEND,
        COMPACT,
        OVERWRITE;

    }
}

