/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.table.store.codegen.ComponentClassLoader;
import org.apache.flink.util.IOUtils;

public class CodeGenLoader {
    static final String FLINK_TABLE_STORE_CODEGEN_FAT_JAR = "flink-table-store-codegen.jar";
    public static final String[] PARENT_FIRST_LOGGING_PATTERNS = new String[]{"org.slf4j", "org.apache.log4j", "org.apache.logging", "org.apache.commons.logging", "ch.qos.logback"};
    private static final String[] OWNER_CLASSPATH = (String[])Stream.concat(Arrays.stream(PARENT_FIRST_LOGGING_PATTERNS), Stream.of("org.codehaus.janino", "org.codehaus.commons", "org.apache.commons.lang3")).toArray(String[]::new);
    private static final String[] COMPONENT_CLASSPATH = new String[]{"org.apache.flink"};
    private final ClassLoader submoduleClassLoader;

    private CodeGenLoader() {
        try {
            ClassLoader flinkClassLoader = CodeGenLoader.class.getClassLoader();
            Path tmpDirectory = Paths.get(ConfigurationUtils.parseTempDirectories(new Configuration())[0], new String[0]);
            Files.createDirectories(tmpDirectory, new FileAttribute[0]);
            Path delegateJar = this.extractResource(FLINK_TABLE_STORE_CODEGEN_FAT_JAR, flinkClassLoader, tmpDirectory, "Flink table store codegen could not be found.\nIf you're running a test, please make sure you've built the codegen modules by running\nmvn clean package -pl flink-table-store-codegen,flink-table-store-codegen-loader -DskipTests");
            this.submoduleClassLoader = new ComponentClassLoader(new URL[]{delegateJar.toUri().toURL()}, flinkClassLoader, OWNER_CLASSPATH, COMPONENT_CLASSPATH);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize the table planner components loader.", e);
        }
    }

    private Path extractResource(String resourceName, ClassLoader flinkClassLoader, Path tmpDirectory, String errorMessage) throws IOException {
        CharSequence[] splitName = resourceName.split("\\.");
        splitName[0] = splitName[0] + "_" + UUID.randomUUID();
        Path tempFile = Files.createFile(tmpDirectory.resolve(String.join((CharSequence)".", splitName)), new FileAttribute[0]);
        InputStream resourceStream = flinkClassLoader.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new RuntimeException(errorMessage);
        }
        IOUtils.copyBytes(resourceStream, Files.newOutputStream(tempFile, new OpenOption[0]));
        return tempFile;
    }

    public static CodeGenLoader getInstance() {
        return CodegenLoaderHolder.INSTANCE;
    }

    public <T> T discover(Class<T> clazz) {
        ArrayList results = new ArrayList();
        ServiceLoader.load(clazz, this.submoduleClassLoader).iterator().forEachRemaining(results::add);
        if (results.size() != 1) {
            throw new RuntimeException("Found " + results.size() + " classes implementing " + clazz.getName() + ". They are:\n" + results.stream().map(t -> t.getClass().getName()).collect(Collectors.joining("\n")));
        }
        return (T)results.get(0);
    }

    private static class CodegenLoaderHolder {
        private static final CodeGenLoader INSTANCE = new CodeGenLoader();

        private CodegenLoaderHolder() {
        }
    }
}

