/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;

public class PerJobCheckpointRecoveryFactory<T extends CompletedCheckpointStore>
implements CheckpointRecoveryFactory {
    private final CheckpointStoreRecoveryHelper<T> checkpointStoreRecoveryHelper;
    private final Supplier<CheckpointIDCounter> checkpointIDCounterPerJobFactory;
    private final ConcurrentMap<JobID, T> store;
    private final ConcurrentMap<JobID, CheckpointIDCounter> counter;

    @VisibleForTesting
    public static <T extends CompletedCheckpointStore> CheckpointRecoveryFactory withoutCheckpointStoreRecovery(IntFunction<T> storeFn) {
        return new PerJobCheckpointRecoveryFactory<CompletedCheckpointStore>((maxCheckpoints, previous, sharedStateRegistry, ioExecutor, restoreMode) -> {
            if (previous != null) {
                throw new UnsupportedOperationException("Checkpoint store recovery is not supported.");
            }
            return (CompletedCheckpointStore)storeFn.apply(maxCheckpoints);
        });
    }

    public PerJobCheckpointRecoveryFactory(CheckpointStoreRecoveryHelper<T> checkpointStoreRecoveryHelper) {
        this(checkpointStoreRecoveryHelper, StandaloneCheckpointIDCounter::new);
    }

    public PerJobCheckpointRecoveryFactory(CheckpointStoreRecoveryHelper<T> checkpointStoreRecoveryHelper, Supplier<CheckpointIDCounter> checkpointIDCounterPerJobFactory) {
        this.checkpointIDCounterPerJobFactory = checkpointIDCounterPerJobFactory;
        this.store = new ConcurrentHashMap<JobID, T>();
        this.counter = new ConcurrentHashMap<JobID, CheckpointIDCounter>();
        this.checkpointStoreRecoveryHelper = checkpointStoreRecoveryHelper;
    }

    @Override
    public CompletedCheckpointStore createRecoveredCompletedCheckpointStore(JobID jobId, int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, RestoreMode restoreMode) {
        return this.store.compute(jobId, (key, previous) -> this.checkpointStoreRecoveryHelper.recoverCheckpointStore(maxNumberOfCheckpointsToRetain, previous, sharedStateRegistryFactory, ioExecutor, restoreMode));
    }

    @Override
    public CheckpointIDCounter createCheckpointIDCounter(JobID jobId) {
        return this.counter.computeIfAbsent(jobId, jId -> this.checkpointIDCounterPerJobFactory.get());
    }

    @Internal
    public static interface CheckpointStoreRecoveryHelper<StoreType extends CompletedCheckpointStore> {
        public StoreType recoverCheckpointStore(int var1, @Nullable StoreType var2, SharedStateRegistryFactory var3, Executor var4, RestoreMode var5);
    }
}

