/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.store.file.compact.CompactUnit;
import org.apache.flink.table.store.file.mergetree.LevelSortedRun;
import org.apache.flink.table.store.file.mergetree.SortedRun;
import org.apache.flink.table.store.file.mergetree.compact.CompactStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalCompaction
implements CompactStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(UniversalCompaction.class);
    private final int maxSizeAmp;
    private final int sizeRatio;
    private final int numRunCompactionTrigger;
    private final int maxSortedRunNum;

    public UniversalCompaction(int maxSizeAmp, int sizeRatio, int numRunCompactionTrigger, int maxSortedRunNum) {
        this.maxSizeAmp = maxSizeAmp;
        this.sizeRatio = sizeRatio;
        this.numRunCompactionTrigger = numRunCompactionTrigger;
        this.maxSortedRunNum = maxSortedRunNum;
    }

    @Override
    public Optional<CompactUnit> pick(int numLevels, List<LevelSortedRun> runs) {
        int maxLevel = numLevels - 1;
        CompactUnit unit = this.pickForSizeAmp(maxLevel, runs);
        if (unit != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to size amplification");
            }
            return Optional.of(unit);
        }
        unit = this.pickForSizeRatio(maxLevel, runs);
        if (unit != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to size ratio");
            }
            return Optional.of(unit);
        }
        if (runs.size() > this.numRunCompactionTrigger) {
            int candidateCount = runs.size() - this.numRunCompactionTrigger + 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to file num");
            }
            return Optional.ofNullable(this.pickForSizeRatio(maxLevel, runs, candidateCount));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    CompactUnit pickForSizeAmp(int maxLevel, List<LevelSortedRun> runs) {
        long earliestRunSize;
        if (runs.size() < this.numRunCompactionTrigger) {
            return null;
        }
        long candidateSize = runs.subList(0, runs.size() - 1).stream().map(LevelSortedRun::run).mapToLong(SortedRun::totalSize).sum();
        if (candidateSize * 100L > (long)this.maxSizeAmp * (earliestRunSize = runs.get(runs.size() - 1).run().totalSize())) {
            return CompactUnit.fromLevelRuns(maxLevel, runs);
        }
        return null;
    }

    @VisibleForTesting
    CompactUnit pickForSizeRatio(int maxLevel, List<LevelSortedRun> runs) {
        if (runs.size() < this.numRunCompactionTrigger) {
            return null;
        }
        return this.pickForSizeRatio(maxLevel, runs, 1);
    }

    private CompactUnit pickForSizeRatio(int maxLevel, List<LevelSortedRun> runs, int candidateCount) {
        LevelSortedRun next;
        long candidateSize = this.candidateSize(runs, candidateCount);
        for (int i = candidateCount; i < runs.size() && !((double)candidateSize * (100.0 + (double)this.sizeRatio) / 100.0 < (double)(next = runs.get(i)).run().totalSize()); ++i) {
            candidateSize += next.run().totalSize();
            ++candidateCount;
        }
        if (candidateCount > 1) {
            return UniversalCompaction.createUnit(runs, maxLevel, candidateCount, this.maxSortedRunNum);
        }
        return null;
    }

    private long candidateSize(List<LevelSortedRun> runs, int candidateCount) {
        long size = 0L;
        for (int i = 0; i < candidateCount; ++i) {
            size += runs.get(i).run().totalSize();
        }
        return size;
    }

    @VisibleForTesting
    static CompactUnit createUnit(List<LevelSortedRun> runs, int maxLevel, int runCount, int maxSortedRunNum) {
        if (runCount > maxSortedRunNum) {
            runCount = maxSortedRunNum;
        }
        int outputLevel = runCount == runs.size() ? maxLevel : Math.max(0, runs.get(runCount).level() - 1);
        return CompactUnit.fromLevelRuns(outputLevel, runs.subList(0, runCount));
    }
}

