/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.window;

import java.time.ZoneId;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.window.WindowJoinOperator;
import org.apache.flink.util.Preconditions;

public class WindowJoinOperatorBuilder {
    private TypeSerializer<RowData> leftSerializer;
    private TypeSerializer<RowData> rightSerializer;
    private GeneratedJoinCondition generatedJoinCondition;
    private int leftWindowEndIndex = -1;
    private int rightWindowEndIndex = -1;
    private boolean[] filterNullKeys;
    private FlinkJoinType joinType;
    private ZoneId shiftTimeZone = ZoneId.of("UTC");

    public static WindowJoinOperatorBuilder builder() {
        return new WindowJoinOperatorBuilder();
    }

    public WindowJoinOperatorBuilder leftSerializer(TypeSerializer<RowData> leftSerializer) {
        this.leftSerializer = leftSerializer;
        return this;
    }

    public WindowJoinOperatorBuilder rightSerializer(TypeSerializer<RowData> rightSerializer) {
        this.rightSerializer = rightSerializer;
        return this;
    }

    public WindowJoinOperatorBuilder generatedJoinCondition(GeneratedJoinCondition generatedJoinCondition) {
        this.generatedJoinCondition = generatedJoinCondition;
        return this;
    }

    public WindowJoinOperatorBuilder filterNullKeys(boolean[] filterNullKeys) {
        this.filterNullKeys = filterNullKeys;
        return this;
    }

    public WindowJoinOperatorBuilder joinType(FlinkJoinType joinType) {
        this.joinType = joinType;
        return this;
    }

    public WindowJoinOperatorBuilder leftWindowEndIndex(int leftWindowEndIndex) {
        this.leftWindowEndIndex = leftWindowEndIndex;
        return this;
    }

    public WindowJoinOperatorBuilder rightWindowEndIndex(int rightWindowEndIndex) {
        this.rightWindowEndIndex = rightWindowEndIndex;
        return this;
    }

    public WindowJoinOperatorBuilder withShiftTimezone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public WindowJoinOperator build() {
        Preconditions.checkNotNull(this.leftSerializer);
        Preconditions.checkNotNull(this.rightSerializer);
        Preconditions.checkNotNull(this.generatedJoinCondition);
        Preconditions.checkNotNull(this.filterNullKeys);
        Preconditions.checkNotNull(this.joinType);
        Preconditions.checkArgument(this.leftWindowEndIndex >= 0, String.format("Illegal window end index %s, it should not be negative!", this.leftWindowEndIndex));
        Preconditions.checkArgument(this.rightWindowEndIndex >= 0, String.format("Illegal window end index %s, it should not be negative!", this.rightWindowEndIndex));
        switch (this.joinType) {
            case INNER: {
                return new WindowJoinOperator.InnerJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, this.shiftTimeZone);
            }
            case SEMI: {
                return new WindowJoinOperator.SemiAntiJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, false, this.shiftTimeZone);
            }
            case ANTI: {
                return new WindowJoinOperator.SemiAntiJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, true, this.shiftTimeZone);
            }
            case LEFT: {
                return new WindowJoinOperator.LeftOuterJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, this.shiftTimeZone);
            }
            case RIGHT: {
                return new WindowJoinOperator.RightOuterJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, this.shiftTimeZone);
            }
            case FULL: {
                return new WindowJoinOperator.FullOuterJoinOperator(this.leftSerializer, this.rightSerializer, this.generatedJoinCondition, this.leftWindowEndIndex, this.rightWindowEndIndex, this.filterNullKeys, this.shiftTimeZone);
            }
        }
        throw new IllegalArgumentException("Invalid join type: " + (Object)((Object)this.joinType));
    }
}

