/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class FlinkJobTerminatedWithoutCancellationException
extends FlinkException {
    private static final long serialVersionUID = 2294698055059659025L;
    private final JobStatus jobStatus;

    public FlinkJobTerminatedWithoutCancellationException(JobID jobId, JobStatus jobStatus) {
        super(String.format("Flink job (%s) was not canceled, but instead %s.", new Object[]{jobId, FlinkJobTerminatedWithoutCancellationException.assertNotCanceled(jobStatus)}));
        this.jobStatus = jobStatus;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    private static JobStatus assertNotCanceled(JobStatus jobStatus) {
        Preconditions.checkState(jobStatus != JobStatus.CANCELED);
        return jobStatus;
    }
}

