/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import org.apache.flink.table.data.StringData;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TableStoreVarcharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveVarcharObjectInspector {
    private final int len;

    public TableStoreVarcharObjectInspector(int len) {
        super((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)len));
        this.len = len;
    }

    public HiveVarchar getPrimitiveJavaObject(Object o) {
        return o == null ? null : new HiveVarchar(o.toString(), this.len);
    }

    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        HiveVarchar hiveVarchar = this.getPrimitiveJavaObject(o);
        return hiveVarchar == null ? null : new HiveVarcharWritable(hiveVarchar);
    }

    public Object copyObject(Object o) {
        if (o instanceof StringData) {
            return StringData.fromString(o.toString());
        }
        if (o instanceof HiveVarchar) {
            HiveVarchar hiveVarchar = (HiveVarchar)o;
            return new HiveVarchar(hiveVarchar, this.len);
        }
        return o;
    }
}

