/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import java.util.ArrayDeque;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public abstract class SlidingOverFrame
implements OverWindowFrame {
    private final RowType inputType;
    private final RowType valueType;
    private GeneratedAggsHandleFunction aggsHandleFunction;
    private transient AggsHandleFunction processor;
    transient RowDataSerializer inputSer;
    private transient RowDataSerializer valueSer;
    transient ResettableExternalBuffer.BufferIterator inputIterator;
    transient BinaryRowData nextRow;
    transient ArrayDeque<RowData> buffer;
    private transient RowData accValue;

    public SlidingOverFrame(RowType inputType, RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction) {
        this.inputType = inputType;
        this.valueType = valueType;
        this.aggsHandleFunction = aggsHandleFunction;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        this.inputSer = new RowDataSerializer(this.inputType);
        this.valueSer = new RowDataSerializer(this.valueType);
        ClassLoader cl = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(cl);
        this.processor.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.buffer = new ArrayDeque();
        this.aggsHandleFunction = null;
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        if (this.inputIterator != null) {
            this.inputIterator.close();
        }
        this.inputIterator = rows.newIterator();
        this.nextRow = OverWindowFrame.getNextOrNull(this.inputIterator);
        this.buffer.clear();
        this.processor.setAccumulators(this.processor.createAccumulators());
    }

    RowData accumulateBuffer(boolean bufferUpdated) throws Exception {
        if (bufferUpdated) {
            this.processor.setAccumulators(this.processor.createAccumulators());
            for (RowData row : this.buffer) {
                this.processor.accumulate(row);
            }
            this.accValue = this.valueSer.copy(this.processor.getValue());
        }
        return this.accValue;
    }
}

