/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.Preconditions;

public class ZooKeeperCheckpointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final CuratorFramework client;
    private final Configuration config;
    private final Executor executor;

    public ZooKeeperCheckpointRecoveryFactory(CuratorFramework client, Configuration config, Executor executor) {
        this.client = Preconditions.checkNotNull(client, "Curator client");
        this.config = Preconditions.checkNotNull(config, "Configuration");
        this.executor = Preconditions.checkNotNull(executor, "Executor");
    }

    @Override
    public CompletedCheckpointStore createRecoveredCompletedCheckpointStore(JobID jobId, int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, RestoreMode restoreMode) throws Exception {
        return ZooKeeperUtils.createCompletedCheckpoints(ZooKeeperUtils.useNamespaceAndEnsurePath(this.client, ZooKeeperUtils.getPathForJob(jobId)), this.config, maxNumberOfCheckpointsToRetain, sharedStateRegistryFactory, ioExecutor, this.executor, restoreMode);
    }

    @Override
    public CheckpointIDCounter createCheckpointIDCounter(JobID jobID) throws Exception {
        return ZooKeeperUtils.createCheckpointIDCounter(ZooKeeperUtils.useNamespaceAndEnsurePath(this.client, ZooKeeperUtils.getPathForJob(jobID)));
    }
}

