/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.hive.HiveTypeUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveSchema {
    private final TableSchema tableSchema;

    private HiveSchema(TableSchema tableSchema) {
        this.tableSchema = tableSchema;
    }

    public List<String> fieldNames() {
        return this.tableSchema.fieldNames();
    }

    public List<LogicalType> fieldTypes() {
        return this.tableSchema.logicalRowType().getChildren();
    }

    public List<String> fieldComments() {
        return this.tableSchema.fields().stream().map(DataField::description).collect(Collectors.toList());
    }

    public static HiveSchema extract(Properties properties) {
        String location = properties.getProperty("location");
        if (location == null) {
            String tableName = properties.getProperty("name");
            throw new UnsupportedOperationException("Location property is missing for table " + tableName + ". Currently Flink table store only supports external table for Hive so location property must be set.");
        }
        TableSchema tableSchema = new SchemaManager(new Path(location)).latest().orElseThrow(() -> new IllegalArgumentException("Schema file not found in location " + location + ". Please create table first."));
        if (properties.containsKey("columns") && properties.containsKey("columns.types")) {
            String columnNames = properties.getProperty("columns");
            String columnNameDelimiter = properties.getProperty("column.name.delimite", String.valueOf(','));
            List<String> names = Arrays.asList(columnNames.split(columnNameDelimiter));
            String columnTypes = properties.getProperty("columns.types");
            ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypes);
            if (names.size() > 0 && typeInfos.size() > 0) {
                HiveSchema.checkSchemaMatched(names, typeInfos, tableSchema);
            }
        }
        return new HiveSchema(tableSchema);
    }

    private static void checkSchemaMatched(List<String> names, List<TypeInfo> typeInfos, TableSchema tableSchema) {
        ArrayList<String> ddlNames = new ArrayList<String>(names);
        ArrayList<TypeInfo> ddlTypeInfos = new ArrayList<TypeInfo>(typeInfos);
        List<String> schemaNames = tableSchema.fieldNames();
        List schemaTypeInfos = tableSchema.logicalRowType().getChildren().stream().map(HiveTypeUtils::logicalTypeToTypeInfo).collect(Collectors.toList());
        while (ddlNames.size() < schemaNames.size()) {
            ddlNames.add(null);
        }
        while (schemaNames.size() < ddlNames.size()) {
            schemaNames.add(null);
        }
        while (ddlTypeInfos.size() < schemaTypeInfos.size()) {
            ddlTypeInfos.add(null);
        }
        while (schemaTypeInfos.size() < ddlTypeInfos.size()) {
            schemaTypeInfos.add(null);
        }
        ArrayList<String> mismatched = new ArrayList<String>();
        for (int i = 0; i < ddlNames.size(); ++i) {
            if (Objects.equals(ddlNames.get(i), schemaNames.get(i)) && Objects.equals(ddlTypeInfos.get(i), schemaTypeInfos.get(i))) continue;
            String ddlField = ddlNames.get(i) == null ? "null" : (String)ddlNames.get(i) + " " + ((TypeInfo)ddlTypeInfos.get(i)).getTypeName();
            String schemaField = schemaNames.get(i) == null ? "null" : schemaNames.get(i) + " " + ((TypeInfo)schemaTypeInfos.get(i)).getTypeName();
            mismatched.add(String.format("Field #%d\nHive DDL          : %s\nTable Store Schema: %s\n", i, ddlField, schemaField));
        }
        if (mismatched.size() > 0) {
            throw new IllegalArgumentException("Hive DDL and table store schema mismatched! It is recommended not to write any column definition as Flink table store external table can read schema from the specified location.\nMismatched fields are:\n" + String.join((CharSequence)"--------------------\n", mismatched));
        }
    }
}

