/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;

public class MergeFunctionHelper {
    private final MergeFunction mergeFunction;
    private RowData rowData;
    private boolean isInitialized;

    public MergeFunctionHelper(MergeFunction mergeFunction) {
        this.mergeFunction = mergeFunction;
    }

    public void reset() {
        this.rowData = null;
        this.mergeFunction.reset();
        this.isInitialized = false;
    }

    public void add(RowData value) {
        if (this.rowData == null) {
            this.rowData = value;
        } else {
            if (!this.isInitialized) {
                this.mergeFunction.add(this.rowData);
                this.isInitialized = true;
            }
            this.mergeFunction.add(value);
        }
    }

    public RowData getValue() {
        return this.isInitialized ? this.mergeFunction.getValue() : this.rowData;
    }
}

