/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.data.DataFileMetaSerializer;
import org.apache.flink.table.store.file.manifest.ManifestCommittable;
import org.apache.flink.table.store.file.utils.SerializationUtils;

public class ManifestCommittableSerializer
implements SimpleVersionedSerializer<ManifestCommittable> {
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public byte[] serialize(ManifestCommittable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        view.writeUTF(obj.identifier());
        this.serializeOffsets(view, obj.logOffsets());
        this.serializeFiles(view, obj.newFiles());
        this.serializeFiles(view, obj.compactBefore());
        this.serializeFiles(view, obj.compactAfter());
        return out.toByteArray();
    }

    private void serializeOffsets(DataOutputViewStreamWrapper view, Map<Integer, Long> offsets) throws IOException {
        view.writeInt(offsets.size());
        for (Map.Entry<Integer, Long> entry : offsets.entrySet()) {
            view.writeInt(entry.getKey());
            view.writeLong(entry.getValue());
        }
    }

    private Map<Integer, Long> deserializeOffsets(DataInputDeserializer view) throws IOException {
        int size = view.readInt();
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            offsets.put(view.readInt(), view.readLong());
        }
        return offsets;
    }

    private void serializeFiles(DataOutputViewStreamWrapper view, Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> files) throws IOException {
        view.writeInt(files.size());
        for (Map.Entry<BinaryRowData, Map<Integer, List<DataFileMeta>>> entry : files.entrySet()) {
            SerializationUtils.serializeBinaryRow(entry.getKey(), view);
            view.writeInt(entry.getValue().size());
            for (Map.Entry<Integer, List<DataFileMeta>> bucketEntry : entry.getValue().entrySet()) {
                view.writeInt(bucketEntry.getKey());
                view.writeInt(bucketEntry.getValue().size());
                for (DataFileMeta file : bucketEntry.getValue()) {
                    this.dataFileSerializer.serialize(file, view);
                }
            }
        }
    }

    private Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> deserializeFiles(DataInputDeserializer view) throws IOException {
        int partNumber = view.readInt();
        HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>> files = new HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>>();
        for (int i = 0; i < partNumber; ++i) {
            BinaryRowData part = SerializationUtils.deserializeBinaryRow(view);
            int bucketNumber = view.readInt();
            HashMap bucketMap = new HashMap();
            files.put(part, bucketMap);
            for (int j = 0; j < bucketNumber; ++j) {
                int bucket = view.readInt();
                int fileNumber = view.readInt();
                ArrayList fileMetas = new ArrayList();
                bucketMap.put(bucket, fileMetas);
                for (int k = 0; k < fileNumber; ++k) {
                    fileMetas.add(this.dataFileSerializer.deserialize(view));
                }
            }
        }
        return files;
    }

    @Override
    public ManifestCommittable deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return new ManifestCommittable(view.readUTF(), this.deserializeOffsets(view), this.deserializeFiles(view), this.deserializeFiles(view), this.deserializeFiles(view));
    }
}

