/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public abstract class AbstractCatalog
implements Catalog {
    private final String catalogName;
    private final String defaultDatabase;

    public AbstractCatalog(String name, String defaultDatabase) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(name), "name cannot be null or empty");
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(defaultDatabase), "defaultDatabase cannot be null or empty");
        this.catalogName = name;
        this.defaultDatabase = defaultDatabase;
    }

    public String getName() {
        return this.catalogName;
    }

    @Override
    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }
}

