/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.CoordinatorStore;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;

@Internal
public interface OperatorCoordinator
extends CheckpointListener,
AutoCloseable {
    public static final long NO_CHECKPOINT = -1L;

    public void start() throws Exception;

    @Override
    public void close() throws Exception;

    public void handleEventFromOperator(int var1, OperatorEvent var2) throws Exception;

    public void checkpointCoordinator(long var1, CompletableFuture<byte[]> var3) throws Exception;

    @Override
    public void notifyCheckpointComplete(long var1);

    @Override
    default public void notifyCheckpointAborted(long checkpointId) {
    }

    public void resetToCheckpoint(long var1, @Nullable byte[] var3) throws Exception;

    public void subtaskFailed(int var1, @Nullable Throwable var2);

    public void subtaskReset(int var1, long var2);

    public void subtaskReady(int var1, SubtaskGateway var2);

    public static interface Provider
    extends Serializable {
        public OperatorID getOperatorId();

        public OperatorCoordinator create(Context var1) throws Exception;
    }

    public static interface SubtaskGateway {
        public CompletableFuture<Acknowledge> sendEvent(OperatorEvent var1);

        public ExecutionAttemptID getExecution();

        public int getSubtask();
    }

    public static interface Context {
        public OperatorID getOperatorId();

        public void failJob(Throwable var1);

        public int currentParallelism();

        public ClassLoader getUserCodeClassloader();

        public CoordinatorStore getCoordinatorStore();
    }
}

