/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class FailedCheckpointStats
extends PendingCheckpointStats {
    private static final long serialVersionUID = 8000748529515900106L;
    private final long failureTimestamp;
    @Nullable
    private final String failureMsg;

    FailedCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, int numAcknowledgedSubtasks, long checkpointedSize, long stateSize, long processedData, long persistedData, long failureTimestamp, @Nullable SubtaskStateStats latestAcknowledgedSubtask, @Nullable Throwable cause) {
        super(checkpointId, triggerTimestamp, props, totalSubtaskCount, numAcknowledgedSubtasks, taskStats, checkpointedSize, stateSize, processedData, persistedData, latestAcknowledgedSubtask);
        Preconditions.checkArgument(numAcknowledgedSubtasks >= 0, "Negative number of ACKs");
        this.failureTimestamp = failureTimestamp;
        this.failureMsg = cause != null ? cause.getMessage() : null;
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.FAILED;
    }

    @Override
    public long getEndToEndDuration() {
        return Math.max(0L, this.failureTimestamp - this.triggerTimestamp);
    }

    public long getFailureTimestamp() {
        return this.failureTimestamp;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMsg;
    }
}

