/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.mergetree.SortedRun;
import org.apache.flink.table.store.file.mergetree.compact.IntervalPartition;
import org.apache.flink.table.store.table.source.SplitGenerator;
import org.apache.flink.table.store.utils.OrderedPacking;

public class MergeTreeSplitGenerator
implements SplitGenerator {
    private final Comparator<RowData> keyComparator;
    private final long targetSplitSize;
    private final long openFileCost;

    public MergeTreeSplitGenerator(Comparator<RowData> keyComparator, long targetSplitSize, long openFileCost) {
        this.keyComparator = keyComparator;
        this.targetSplitSize = targetSplitSize;
        this.openFileCost = openFileCost;
    }

    @Override
    public List<List<DataFileMeta>> split(List<DataFileMeta> files) {
        List<List<DataFileMeta>> sections = new IntervalPartition(files, this.keyComparator).partition().stream().map(this::flatRun).collect(Collectors.toList());
        return this.packSplits(sections);
    }

    private List<List<DataFileMeta>> packSplits(List<List<DataFileMeta>> sections) {
        Function<List, Long> weightFunc = file -> Math.max(this.totalSize((List<DataFileMeta>)file), this.openFileCost);
        return OrderedPacking.pack(sections, weightFunc, this.targetSplitSize).stream().map(this::flatFiles).collect(Collectors.toList());
    }

    private long totalSize(List<DataFileMeta> section) {
        long size = 0L;
        for (DataFileMeta file : section) {
            size += file.fileSize();
        }
        return size;
    }

    private List<DataFileMeta> flatRun(List<SortedRun> section) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        section.forEach(run -> files.addAll(run.files()));
        return files;
    }

    private List<DataFileMeta> flatFiles(List<List<DataFileMeta>> section) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        section.forEach(files::addAll);
        return files;
    }
}

