/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;

public class Snapshot {
    public static final long FIRST_SNAPSHOT_ID = 1L;
    private static final String FIELD_ID = "id";
    private static final String FIELD_SCHEMA_ID = "schemaId";
    private static final String FIELD_BASE_MANIFEST_LIST = "baseManifestList";
    private static final String FIELD_DELTA_MANIFEST_LIST = "deltaManifestList";
    private static final String FIELD_COMMIT_USER = "commitUser";
    private static final String FIELD_COMMIT_IDENTIFIER = "commitIdentifier";
    private static final String FIELD_COMMIT_KIND = "commitKind";
    private static final String FIELD_TIME_MILLIS = "timeMillis";
    private static final String FIELD_LOG_OFFSETS = "logOffsets";
    @JsonProperty(value="id")
    private final long id;
    @JsonProperty(value="schemaId")
    private final long schemaId;
    @JsonProperty(value="baseManifestList")
    private final String baseManifestList;
    @JsonProperty(value="deltaManifestList")
    private final String deltaManifestList;
    @JsonProperty(value="commitUser")
    private final String commitUser;
    @JsonProperty(value="commitIdentifier")
    private final String commitIdentifier;
    @JsonProperty(value="commitKind")
    private final CommitKind commitKind;
    @JsonProperty(value="timeMillis")
    private final long timeMillis;
    @JsonProperty(value="logOffsets")
    private final Map<Integer, Long> logOffsets;

    @JsonCreator
    public Snapshot(@JsonProperty(value="id") long id, @JsonProperty(value="schemaId") long schemaId, @JsonProperty(value="baseManifestList") String baseManifestList, @JsonProperty(value="deltaManifestList") String deltaManifestList, @JsonProperty(value="commitUser") String commitUser, @JsonProperty(value="commitIdentifier") String commitIdentifier, @JsonProperty(value="commitKind") CommitKind commitKind, @JsonProperty(value="timeMillis") long timeMillis, @JsonProperty(value="logOffsets") Map<Integer, Long> logOffsets) {
        this.id = id;
        this.schemaId = schemaId;
        this.baseManifestList = baseManifestList;
        this.deltaManifestList = deltaManifestList;
        this.commitUser = commitUser;
        this.commitIdentifier = commitIdentifier;
        this.commitKind = commitKind;
        this.timeMillis = timeMillis;
        this.logOffsets = logOffsets;
    }

    @JsonGetter(value="id")
    public long id() {
        return this.id;
    }

    @JsonGetter(value="schemaId")
    public long schemaId() {
        return this.schemaId;
    }

    @JsonGetter(value="baseManifestList")
    public String baseManifestList() {
        return this.baseManifestList;
    }

    @JsonGetter(value="deltaManifestList")
    public String deltaManifestList() {
        return this.deltaManifestList;
    }

    @JsonGetter(value="commitUser")
    public String commitUser() {
        return this.commitUser;
    }

    @JsonGetter(value="commitIdentifier")
    public String commitIdentifier() {
        return this.commitIdentifier;
    }

    @JsonGetter(value="commitKind")
    public CommitKind commitKind() {
        return this.commitKind;
    }

    @JsonGetter(value="timeMillis")
    public long timeMillis() {
        return this.timeMillis;
    }

    @JsonGetter(value="logOffsets")
    public Map<Integer, Long> getLogOffsets() {
        return this.logOffsets;
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public List<ManifestFileMeta> readAllManifests(ManifestList manifestList) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        result.addAll(manifestList.read(this.baseManifestList));
        result.addAll(manifestList.read(this.deltaManifestList));
        return result;
    }

    public static Snapshot fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Snapshot.class);
    }

    public static Snapshot fromPath(Path path) {
        try {
            String json = FileUtils.readFileUtf8(path);
            return Snapshot.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to read snapshot from path " + path, e);
        }
    }

    public static enum CommitKind {
        APPEND,
        COMPACT,
        OVERWRITE;

    }
}

