/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateListView;
import org.apache.flink.table.runtime.dataview.StateMapView;

@Internal
public final class PerWindowStateDataViewStore
implements StateDataViewStore {
    private static final String NULL_STATE_POSTFIX = "_null_state";
    private final KeyedStateBackend<?> keyedStateBackend;
    private final TypeSerializer<?> windowSerializer;
    private final RuntimeContext ctx;

    public PerWindowStateDataViewStore(KeyedStateBackend<?> keyedStateBackend, TypeSerializer<?> windowSerializer, RuntimeContext runtimeContext) {
        this.keyedStateBackend = keyedStateBackend;
        this.windowSerializer = windowSerializer;
        this.ctx = runtimeContext;
    }

    @Override
    public <N, EK, EV> StateMapView<N, EK, EV> getStateMapView(String stateName, boolean supportNullKey, TypeSerializer<EK> keySerializer, TypeSerializer<EV> valueSerializer) throws Exception {
        MapStateDescriptor<EK, EV> mapStateDescriptor = new MapStateDescriptor<EK, EV>(stateName, keySerializer, valueSerializer);
        MapState mapState = (MapState)this.keyedStateBackend.getOrCreateKeyedState(this.windowSerializer, mapStateDescriptor);
        InternalMapState internalMapState = (InternalMapState)mapState;
        if (supportNullKey) {
            ValueStateDescriptor<EV> nullStateDescriptor = new ValueStateDescriptor<EV>(stateName + NULL_STATE_POSTFIX, valueSerializer);
            ValueState nullState = (ValueState)this.keyedStateBackend.getOrCreateKeyedState(this.windowSerializer, nullStateDescriptor);
            InternalValueState internalNullState = (InternalValueState)nullState;
            return new StateMapView.NamespacedStateMapViewWithKeysNullable(internalMapState, internalNullState);
        }
        return new StateMapView.NamespacedStateMapViewWithKeysNotNull(internalMapState);
    }

    @Override
    public <N, EE> StateListView<N, EE> getStateListView(String stateName, TypeSerializer<EE> elementSerializer) throws Exception {
        ListStateDescriptor<EE> listStateDescriptor = new ListStateDescriptor<EE>(stateName, elementSerializer);
        ListState listState = (ListState)this.keyedStateBackend.getOrCreateKeyedState(this.windowSerializer, listStateDescriptor);
        InternalListState internalListState = (InternalListState)listState;
        return new StateListView.NamespacedStateListView(internalListState);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.ctx;
    }
}

