/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class UnresolvedIdentifier {
    @Nullable
    private final String catalogName;
    @Nullable
    private final String databaseName;
    private final String objectName;

    public static UnresolvedIdentifier of(String ... path) {
        if (path == null) {
            throw new ValidationException("Object identifier can not be null!");
        }
        if (path.length < 1 || path.length > 3) {
            throw new ValidationException("Object identifier must consist of 1 to 3 parts.");
        }
        if (Arrays.stream(path).anyMatch(StringUtils::isNullOrWhitespaceOnly)) {
            throw new ValidationException("Parts of the object identifier are null or whitespace-only.");
        }
        if (path.length == 3) {
            return new UnresolvedIdentifier(path[0], path[1], path[2]);
        }
        if (path.length == 2) {
            return new UnresolvedIdentifier(null, path[0], path[1]);
        }
        return new UnresolvedIdentifier(null, null, path[0]);
    }

    public static UnresolvedIdentifier of(List<String> path) {
        return UnresolvedIdentifier.of(path.toArray(new String[0]));
    }

    public static UnresolvedIdentifier of(ObjectIdentifier objectIdentifier) {
        return UnresolvedIdentifier.of(objectIdentifier.toList());
    }

    private UnresolvedIdentifier(@Nullable String catalogName, @Nullable String databaseName, String objectName) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.objectName = Preconditions.checkNotNull(objectName, "Object name must not be null.");
    }

    public Optional<String> getCatalogName() {
        return Optional.ofNullable(this.catalogName);
    }

    public Optional<String> getDatabaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String asSummaryString() {
        return Stream.of(this.catalogName, this.databaseName, this.objectName).filter(Objects::nonNull).map(EncodingUtils::escapeIdentifier).collect(Collectors.joining("."));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedIdentifier that = (UnresolvedIdentifier)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.databaseName, that.databaseName) && this.objectName.equals(that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.databaseName, this.objectName);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

