/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.legacy.files.StaticFileServerHandler;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.WebMonitorExtension;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebMonitorUtils {
    private static final String WEB_FRONTEND_BOOTSTRAP_CLASS_FQN = "org.apache.flink.runtime.webmonitor.utils.WebFrontendBootstrap";
    private static final Logger LOG = LoggerFactory.getLogger(WebMonitorUtils.class);

    public static <T extends RestfulGateway> Optional<StaticFileServerHandler<T>> tryLoadWebContent(GatewayRetriever<? extends T> leaderRetriever, Time timeout, File tmpDir) throws IOException {
        if (WebMonitorUtils.isFlinkRuntimeWebInClassPath()) {
            return Optional.of(new StaticFileServerHandler<T>(leaderRetriever, timeout, tmpDir));
        }
        return Optional.empty();
    }

    public static WebMonitorExtension loadWebSubmissionExtension(GatewayRetriever<? extends DispatcherGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, CompletableFuture<String> localAddressFuture, Path uploadDir, Executor executor, Configuration configuration) throws FlinkException {
        if (WebMonitorUtils.isFlinkRuntimeWebInClassPath()) {
            try {
                Constructor<?> webSubmissionExtensionConstructor = Class.forName("org.apache.flink.runtime.webmonitor.WebSubmissionExtension").getConstructor(Configuration.class, GatewayRetriever.class, Map.class, CompletableFuture.class, Path.class, Executor.class, Time.class);
                return (WebMonitorExtension)webSubmissionExtensionConstructor.newInstance(configuration, leaderRetriever, responseHeaders, localAddressFuture, uploadDir, executor, timeout);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FlinkException("Could not load web submission extension.", e);
            }
        }
        throw new FlinkException("The module flink-runtime-web could not be found in the class path. Please add this jar in order to enable web based job submission.");
    }

    public static Map<String, String> fromKeyValueJsonArray(String jsonString) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            ObjectMapper m = new ObjectMapper();
            ArrayNode array = (ArrayNode)m.readTree(jsonString);
            Iterator<JsonNode> elements = array.elements();
            while (elements.hasNext()) {
                JsonNode node = elements.next();
                String key = node.get("key").asText();
                String value = node.get("value").asText();
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private WebMonitorUtils() {
        throw new RuntimeException();
    }

    private static boolean isFlinkRuntimeWebInClassPath() {
        try {
            Class.forName(WEB_FRONTEND_BOOTSTRAP_CLASS_FQN);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static class LogFileLocation {
        public final File logFile;
        public final File stdOutFile;
        public final File logDir;

        private LogFileLocation(@Nullable File logFile, @Nullable File stdOutFile, @Nullable File logDir) {
            this.logFile = logFile;
            this.stdOutFile = stdOutFile;
            this.logDir = logDir;
        }

        public static LogFileLocation find(Configuration config) {
            String logEnv = "log.file";
            String logFilePath = System.getProperty("log.file");
            if (logFilePath == null) {
                LOG.warn("Log file environment variable '{}' is not set.", (Object)"log.file");
                logFilePath = config.getString(WebOptions.LOG_PATH);
            }
            if (logFilePath == null || logFilePath.length() < 4) {
                LOG.warn("JobManager log files are unavailable in the web dashboard. Log file location not found in environment variable '{}' or configuration key '{}'.", (Object)"log.file", (Object)WebOptions.LOG_PATH.key());
                return new LogFileLocation(null, null, null);
            }
            String outFilePath = logFilePath.substring(0, logFilePath.length() - 3).concat("out");
            File logFile = LogFileLocation.resolveFileLocation(logFilePath);
            File logDir = null;
            if (logFile != null) {
                logDir = LogFileLocation.resolveFileLocation(logFile.getParent());
            }
            LOG.info("Determined location of main cluster component log file: {}", (Object)logFilePath);
            LOG.info("Determined location of main cluster component stdout file: {}", (Object)outFilePath);
            return new LogFileLocation(logFile, LogFileLocation.resolveFileLocation(outFilePath), logDir);
        }

        private static File resolveFileLocation(String logFilePath) {
            File logFile = new File(logFilePath);
            return logFile.exists() && logFile.canRead() ? logFile : null;
        }
    }
}

