/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collection;
import java.util.List;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.metrics.AbstractLatencyTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateLatencyMetricBase;

class LatencyTrackingListState<K, N, T>
extends AbstractLatencyTrackState<K, N, List<T>, InternalListState<K, N, T>, ListStateLatencyMetrics>
implements InternalListState<K, N, T> {
    LatencyTrackingListState(String stateName, InternalListState<K, N, T> original, LatencyTrackingStateConfig latencyTrackingStateConfig) {
        super(original, new ListStateLatencyMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()));
    }

    @Override
    public Iterable<T> get() throws Exception {
        if (((ListStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnGet()) {
            return this.trackLatencyWithException(() -> (Iterable)((InternalListState)this.original).get(), "listStateGetLatency");
        }
        return (Iterable)((InternalListState)this.original).get();
    }

    @Override
    public void add(T value) throws Exception {
        if (((ListStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnAdd()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).add(value), "listStateAddLatency");
        } else {
            ((InternalListState)this.original).add(value);
        }
    }

    @Override
    public List<T> getInternal() throws Exception {
        return (List)((InternalListState)this.original).getInternal();
    }

    @Override
    public void updateInternal(List<T> valueToStore) throws Exception {
        ((InternalListState)this.original).updateInternal(valueToStore);
    }

    @Override
    public void update(List<T> values) throws Exception {
        if (((ListStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnUpdate()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).update(values), "listStateUpdateLatency");
        } else {
            ((InternalListState)this.original).update(values);
        }
    }

    @Override
    public void addAll(List<T> values) throws Exception {
        if (((ListStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnAddAll()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).addAll(values), "listStateAddAllLatency");
        } else {
            ((InternalListState)this.original).addAll(values);
        }
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (((ListStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnMergeNamespace()) {
            this.trackLatencyWithException(() -> ((InternalListState)this.original).mergeNamespaces(target, sources), "listStateMergeNamespacesLatency");
        } else {
            ((InternalListState)this.original).mergeNamespaces(target, sources);
        }
    }

    static class ListStateLatencyMetrics
    extends StateLatencyMetricBase {
        private static final String LIST_STATE_GET_LATENCY = "listStateGetLatency";
        private static final String LIST_STATE_ADD_LATENCY = "listStateAddLatency";
        private static final String LIST_STATE_ADD_ALL_LATENCY = "listStateAddAllLatency";
        private static final String LIST_STATE_UPDATE_LATENCY = "listStateUpdateLatency";
        private static final String LIST_STATE_MERGE_NAMESPACES_LATENCY = "listStateMergeNamespacesLatency";
        private int getCount = 0;
        private int addCount = 0;
        private int addAllCount = 0;
        private int updateCount = 0;
        private int mergeNamespaceCount = 0;

        private ListStateLatencyMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getAddCount() {
            return this.addCount;
        }

        int getAddAllCount() {
            return this.addAllCount;
        }

        int getUpdateCount() {
            return this.updateCount;
        }

        int getMergeNamespaceCount() {
            return this.mergeNamespaceCount;
        }

        private boolean trackLatencyOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackLatencyOnAdd() {
            this.addCount = this.loopUpdateCounter(this.addCount);
            return this.addCount == 1;
        }

        private boolean trackLatencyOnAddAll() {
            this.addAllCount = this.loopUpdateCounter(this.addAllCount);
            return this.addAllCount == 1;
        }

        private boolean trackLatencyOnUpdate() {
            this.updateCount = this.loopUpdateCounter(this.updateCount);
            return this.updateCount == 1;
        }

        private boolean trackLatencyOnMergeNamespace() {
            this.mergeNamespaceCount = this.loopUpdateCounter(this.mergeNamespaceCount);
            return this.mergeNamespaceCount == 1;
        }
    }
}

