/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;

public class AddSplitEvent<SplitT>
implements OperatorEvent {
    private static final long serialVersionUID = 1L;
    private final int serializerVersion;
    private final ArrayList<byte[]> splits;

    public AddSplitEvent(List<SplitT> splits, SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        this.splits = new ArrayList(splits.size());
        this.serializerVersion = splitSerializer.getVersion();
        for (SplitT split : splits) {
            this.splits.add(splitSerializer.serialize(split));
        }
    }

    public List<SplitT> splits(SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        ArrayList<SplitT> result = new ArrayList<SplitT>(this.splits.size());
        for (byte[] serializedSplit : this.splits) {
            result.add(splitSerializer.deserialize(this.serializerVersion, serializedSplit));
        }
        return result;
    }

    public String toString() {
        return String.format("AddSplitEvents[%s]", this.splits);
    }
}

