/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.util.Preconditions;

public class ZooKeeperModule
implements SecurityModule {
    private static final String ZOOKEEPER_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    private static final String ZK_ENABLE_CLIENT_SASL = "zookeeper.sasl.client";
    private static final String ZK_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    private static final String ZK_LOGIN_CONTEXT_NAME = "zookeeper.sasl.clientconfig";
    private final SecurityConfiguration securityConfig;
    private String priorSaslEnable;
    private String priorServiceName;
    private String priorLoginContextName;

    public ZooKeeperModule(SecurityConfiguration securityConfig) {
        this.securityConfig = Preconditions.checkNotNull(securityConfig);
    }

    @Override
    public void install() throws SecurityModule.SecurityInstallException {
        this.priorSaslEnable = System.getProperty(ZK_ENABLE_CLIENT_SASL, null);
        System.setProperty(ZK_ENABLE_CLIENT_SASL, String.valueOf(!this.securityConfig.isZkSaslDisable()));
        this.priorServiceName = System.getProperty("zookeeper.sasl.client.username", null);
        if (!"zookeeper".equals(this.securityConfig.getZooKeeperServiceName())) {
            System.setProperty("zookeeper.sasl.client.username", this.securityConfig.getZooKeeperServiceName());
        }
        this.priorLoginContextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME, null);
        if (!"Client".equals(this.securityConfig.getZooKeeperLoginContextName())) {
            System.setProperty(ZK_LOGIN_CONTEXT_NAME, this.securityConfig.getZooKeeperLoginContextName());
        }
    }

    @Override
    public void uninstall() throws SecurityModule.SecurityInstallException {
        if (this.priorSaslEnable != null) {
            System.setProperty(ZK_ENABLE_CLIENT_SASL, this.priorSaslEnable);
        } else {
            System.clearProperty(ZK_ENABLE_CLIENT_SASL);
        }
        if (this.priorServiceName != null) {
            System.setProperty("zookeeper.sasl.client.username", this.priorServiceName);
        } else {
            System.clearProperty("zookeeper.sasl.client.username");
        }
        if (this.priorLoginContextName != null) {
            System.setProperty(ZK_LOGIN_CONTEXT_NAME, this.priorLoginContextName);
        } else {
            System.clearProperty(ZK_LOGIN_CONTEXT_NAME);
        }
    }
}

