/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class FailureHandlingResultSnapshot {
    @Nullable
    private final Execution rootCauseExecution;
    private final Throwable rootCause;
    private final long timestamp;
    private final Set<Execution> concurrentlyFailedExecutions;

    public static FailureHandlingResultSnapshot create(FailureHandlingResult failureHandlingResult, Function<ExecutionVertexID, Execution> latestExecutionLookup) {
        Execution rootCauseExecution = failureHandlingResult.getExecutionVertexIdOfFailedTask().map(latestExecutionLookup).orElse(null);
        Preconditions.checkArgument(rootCauseExecution == null || rootCauseExecution.getFailureInfo().isPresent(), String.format("The execution %s didn't provide a failure info even though the corresponding ExecutionVertex %s is marked as having handled the root cause of this failure.", rootCauseExecution != null ? rootCauseExecution.getAttemptId() : "(null)", failureHandlingResult.getExecutionVertexIdOfFailedTask().map(Objects::toString).orElse("(null)")));
        ExecutionVertexID rootCauseExecutionVertexId = failureHandlingResult.getExecutionVertexIdOfFailedTask().orElse(null);
        Set<Execution> concurrentlyFailedExecutions = failureHandlingResult.getVerticesToRestart().stream().filter(executionVertexId -> !executionVertexId.equals(rootCauseExecutionVertexId)).map(latestExecutionLookup).filter(execution -> execution.getFailureInfo().isPresent()).collect(Collectors.toSet());
        return new FailureHandlingResultSnapshot(rootCauseExecution, ErrorInfo.handleMissingThrowable(failureHandlingResult.getError()), failureHandlingResult.getTimestamp(), concurrentlyFailedExecutions);
    }

    @VisibleForTesting
    FailureHandlingResultSnapshot(@Nullable Execution rootCauseExecution, Throwable rootCause, long timestamp, Set<Execution> concurrentlyFailedExecutions) {
        Preconditions.checkArgument(rootCauseExecution == null || !concurrentlyFailedExecutions.contains(rootCauseExecution), "The rootCauseExecution should not be part of the concurrentlyFailedExecutions map.");
        this.rootCauseExecution = rootCauseExecution;
        this.rootCause = Preconditions.checkNotNull(rootCause);
        this.timestamp = timestamp;
        this.concurrentlyFailedExecutions = Preconditions.checkNotNull(concurrentlyFailedExecutions);
    }

    public Optional<Execution> getRootCauseExecution() {
        return Optional.ofNullable(this.rootCauseExecution);
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Iterable<Execution> getConcurrentlyFailedExecution() {
        return Collections.unmodifiableSet(this.concurrentlyFailedExecutions);
    }
}

