/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.async.OperationResultStatus;
import org.apache.flink.util.Preconditions;

public class OperationResult<R> {
    private final OperationResultStatus status;
    @Nullable
    private final R result;
    @Nullable
    private final Throwable throwable;

    private OperationResult(OperationResultStatus status, R result, Throwable throwable) {
        this.status = status;
        this.result = result;
        this.throwable = throwable;
    }

    public boolean isFinished() {
        return this.status == OperationResultStatus.SUCCESS || this.status == OperationResultStatus.FAILURE;
    }

    public OperationResultStatus getStatus() {
        return this.status;
    }

    public R getResult() {
        Preconditions.checkNotNull(this.result);
        return this.result;
    }

    public Throwable getThrowable() {
        Preconditions.checkNotNull(this.throwable);
        return this.throwable;
    }

    public static <R> OperationResult<R> failure(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new OperationResult<Object>(OperationResultStatus.FAILURE, null, throwable);
    }

    public static <R> OperationResult<R> success(R result) {
        Preconditions.checkNotNull(result);
        return new OperationResult<R>(OperationResultStatus.SUCCESS, result, null);
    }

    public static <R> OperationResult<R> inProgress() {
        return new OperationResult<Object>(OperationResultStatus.IN_PROGRESS, null, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OperationResult that = (OperationResult)other;
        return this.status == that.status && Objects.equals(this.result, that.result) && Objects.equals(this.throwable, that.throwable);
    }
}

