/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.runner.DispatcherLeaderProcess;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractDispatcherLeaderProcess
implements DispatcherLeaderProcess {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private final UUID leaderSessionId;
    private final FatalErrorHandler fatalErrorHandler;
    private final CompletableFuture<DispatcherGateway> dispatcherGatewayFuture;
    private final CompletableFuture<String> leaderAddressFuture;
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private State state;
    @Nullable
    private DispatcherGatewayService dispatcherService;

    AbstractDispatcherLeaderProcess(UUID leaderSessionId, FatalErrorHandler fatalErrorHandler) {
        this.leaderSessionId = leaderSessionId;
        this.fatalErrorHandler = fatalErrorHandler;
        this.dispatcherGatewayFuture = new CompletableFuture();
        this.leaderAddressFuture = this.dispatcherGatewayFuture.thenApply(RpcGateway::getAddress);
        this.terminationFuture = new CompletableFuture();
        this.shutDownFuture = new CompletableFuture();
        this.state = State.CREATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    State getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public final void start() {
        this.runIfStateIs(State.CREATED, this::startInternal);
    }

    private void startInternal() {
        this.log.info("Start {}.", (Object)this.getClass().getSimpleName());
        this.state = State.RUNNING;
        this.onStart();
    }

    @Override
    public final UUID getLeaderSessionId() {
        return this.leaderSessionId;
    }

    @Override
    public final CompletableFuture<DispatcherGateway> getDispatcherGateway() {
        return this.dispatcherGatewayFuture;
    }

    @Override
    public final CompletableFuture<String> getLeaderAddressFuture() {
        return this.leaderAddressFuture;
    }

    @Override
    public CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    protected final Optional<DispatcherGatewayService> getDispatcherService() {
        return Optional.ofNullable(this.dispatcherService);
    }

    @Override
    public final CompletableFuture<Void> closeAsync() {
        this.runIfStateIsNot(State.STOPPED, this::closeInternal);
        return this.terminationFuture;
    }

    private void closeInternal() {
        this.log.info("Stopping {}.", (Object)this.getClass().getSimpleName());
        this.state = State.STOPPED;
        CompletableFuture<Void> dispatcherServiceTerminationFuture = this.closeDispatcherService();
        CompletableFuture<Void> onCloseTerminationFuture = FutureUtils.composeAfterwards(dispatcherServiceTerminationFuture, this::onClose);
        FutureUtils.forward(onCloseTerminationFuture, this.terminationFuture);
    }

    private CompletableFuture<Void> closeDispatcherService() {
        if (this.dispatcherService != null) {
            return this.dispatcherService.closeAsync();
        }
        return FutureUtils.completedVoidFuture();
    }

    protected abstract void onStart();

    protected CompletableFuture<Void> onClose() {
        return FutureUtils.completedVoidFuture();
    }

    final void completeDispatcherSetup(DispatcherGatewayService dispatcherService) {
        this.runIfStateIs(State.RUNNING, () -> this.completeDispatcherSetupInternal(dispatcherService));
    }

    private void completeDispatcherSetupInternal(DispatcherGatewayService createdDispatcherService) {
        Preconditions.checkState(this.dispatcherService == null, "The DispatcherGatewayService can only be set once.");
        this.dispatcherService = createdDispatcherService;
        this.dispatcherGatewayFuture.complete(createdDispatcherService.getGateway());
        FutureUtils.forward(createdDispatcherService.getShutDownFuture(), this.shutDownFuture);
        this.handleUnexpectedDispatcherServiceTermination(createdDispatcherService);
    }

    private void handleUnexpectedDispatcherServiceTermination(DispatcherGatewayService createdDispatcherService) {
        createdDispatcherService.getTerminationFuture().whenComplete((ignored, throwable) -> this.runIfStateIs(State.RUNNING, () -> this.handleError(new FlinkException("Unexpected termination of DispatcherService.", (Throwable)throwable))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <V> Optional<V> supplyUnsynchronizedIfRunning(Supplier<V> supplier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.RUNNING) {
                return Optional.empty();
            }
        }
        return Optional.of(supplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <V> Optional<V> supplyIfRunning(Supplier<V> supplier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.RUNNING) {
                return Optional.empty();
            }
            return Optional.of(supplier.get());
        }
    }

    final void runIfStateIs(State expectedState, Runnable action) {
        this.runIfState(expectedState::equals, action);
    }

    private void runIfStateIsNot(State notExpectedState, Runnable action) {
        this.runIfState(state -> !notExpectedState.equals(state), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIfState(Predicate<State> actionPredicate, Runnable action) {
        Object object = this.lock;
        synchronized (object) {
            if (actionPredicate.test(this.state)) {
                action.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> Void onErrorIfRunning(T ignored, Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.RUNNING) {
                return null;
            }
        }
        if (throwable != null) {
            this.handleError(throwable);
        }
        return null;
    }

    private void handleError(Throwable throwable) {
        this.closeAsync();
        this.fatalErrorHandler.onFatalError(throwable);
    }

    public static interface DispatcherGatewayService
    extends AutoCloseableAsync {
        public DispatcherGateway getGateway();

        public CompletableFuture<Void> onRemovedJobGraph(JobID var1);

        public CompletableFuture<ApplicationStatus> getShutDownFuture();

        public CompletableFuture<Void> getTerminationFuture();
    }

    public static interface DispatcherGatewayServiceFactory {
        public DispatcherGatewayService create(DispatcherId var1, Collection<JobGraph> var2, Collection<JobResult> var3, JobGraphWriter var4, JobResultStore var5);
    }

    protected static enum State {
        CREATED,
        RUNNING,
        STOPPED;

    }
}

