/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class AsyncSinkBase<InputT, RequestEntryT extends Serializable>
implements StatefulSink<InputT, BufferedRequestState<RequestEntryT>> {
    private final ElementConverter<InputT, RequestEntryT> elementConverter;
    private final int maxBatchSize;
    private final int maxInFlightRequests;
    private final int maxBufferedRequests;
    private final long maxBatchSizeInBytes;
    private final long maxTimeInBufferMS;
    private final long maxRecordSizeInBytes;

    protected AsyncSinkBase(ElementConverter<InputT, RequestEntryT> elementConverter, int maxBatchSize, int maxInFlightRequests, int maxBufferedRequests, long maxBatchSizeInBytes, long maxTimeInBufferMS, long maxRecordSizeInBytes) {
        this.elementConverter = Preconditions.checkNotNull(elementConverter, "ElementConverter must be not null when initializing the AsyncSinkBase.");
        this.maxBatchSize = maxBatchSize;
        this.maxInFlightRequests = maxInFlightRequests;
        this.maxBufferedRequests = maxBufferedRequests;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
        this.maxTimeInBufferMS = maxTimeInBufferMS;
        this.maxRecordSizeInBytes = maxRecordSizeInBytes;
    }

    protected ElementConverter<InputT, RequestEntryT> getElementConverter() {
        return this.elementConverter;
    }

    protected int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    protected int getMaxInFlightRequests() {
        return this.maxInFlightRequests;
    }

    protected int getMaxBufferedRequests() {
        return this.maxBufferedRequests;
    }

    protected long getMaxBatchSizeInBytes() {
        return this.maxBatchSizeInBytes;
    }

    protected long getMaxTimeInBufferMS() {
        return this.maxTimeInBufferMS;
    }

    protected long getMaxRecordSizeInBytes() {
        return this.maxRecordSizeInBytes;
    }
}

