/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.IOException;
import java.util.List;
import org.apache.flink.table.store.connector.sink.Committable;
import org.apache.flink.table.store.connector.sink.Committer;
import org.apache.flink.table.store.connector.sink.LogOffsetCommittable;
import org.apache.flink.table.store.file.manifest.ManifestCommittable;
import org.apache.flink.table.store.table.sink.FileCommittable;
import org.apache.flink.table.store.table.sink.TableCommit;

public class StoreCommitter
implements Committer {
    private final TableCommit commit;

    public StoreCommitter(TableCommit commit) {
        this.commit = commit;
    }

    @Override
    public List<ManifestCommittable> filterRecoveredCommittables(List<ManifestCommittable> globalCommittables) {
        return this.commit.filterCommitted(globalCommittables);
    }

    @Override
    public ManifestCommittable combine(long checkpointId, List<Committable> committables) {
        ManifestCommittable fileCommittable = new ManifestCommittable(String.valueOf(checkpointId));
        for (Committable committable : committables) {
            switch (committable.kind()) {
                case FILE: {
                    FileCommittable file = (FileCommittable)committable.wrappedCommittable();
                    fileCommittable.addFileCommittable(file.partition(), file.bucket(), file.increment());
                    break;
                }
                case LOG_OFFSET: {
                    LogOffsetCommittable offset = (LogOffsetCommittable)committable.wrappedCommittable();
                    fileCommittable.addLogOffset(offset.bucket(), offset.offset());
                }
            }
        }
        return fileCommittable;
    }

    @Override
    public void commit(List<ManifestCommittable> committables) throws IOException, InterruptedException {
        this.commit.commit(committables);
    }

    @Override
    public void close() throws Exception {
        this.commit.close();
    }
}

