/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.resource;

import java.util.HashMap;
import java.util.Locale;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum ResourceType {
    UNKNOWN(0),
    ANY(1),
    TOPIC(2),
    GROUP(3),
    CLUSTER(4),
    TRANSACTIONAL_ID(5),
    DELEGATION_TOKEN(6);

    private static final HashMap<Byte, ResourceType> CODE_TO_VALUE;
    private final byte code;

    public static ResourceType fromString(String str) throws IllegalArgumentException {
        try {
            return ResourceType.valueOf(str.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static ResourceType fromCode(byte code) {
        ResourceType resourceType = CODE_TO_VALUE.get(code);
        if (resourceType == null) {
            return UNKNOWN;
        }
        return resourceType;
    }

    private ResourceType(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        CODE_TO_VALUE = new HashMap();
        for (ResourceType resourceType : ResourceType.values()) {
            CODE_TO_VALUE.put(resourceType.code, resourceType);
        }
    }
}

