/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class StopReplicaResponse
extends AbstractResponse {
    private final StopReplicaResponseData data;

    public StopReplicaResponse(StopReplicaResponseData data) {
        super(ApiKeys.STOP_REPLICA);
        this.data = data;
    }

    public List<StopReplicaResponseData.StopReplicaPartitionError> partitionErrors() {
        return this.data.partitionErrors();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(this.error(), this.data.partitionErrors().size() + 1);
        }
        Map<Errors, Integer> errors = this.errorCounts(this.data.partitionErrors().stream().map(p -> Errors.forCode(p.errorCode())));
        this.updateErrorCounts(errors, Errors.forCode(this.data.errorCode()));
        return errors;
    }

    public static StopReplicaResponse parse(ByteBuffer buffer, short version) {
        return new StopReplicaResponse(new StopReplicaResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public StopReplicaResponseData data() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }
}

