/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.DataFieldSerializer;
import org.apache.flink.table.store.file.schema.SchemaSerializer;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.JsonSerializer;

@Internal
public class JsonSerdeUtil {
    private static final ObjectMapper OBJECT_MAPPER_INSTANCE = new ObjectMapper();

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER_INSTANCE.reader().readValue(json, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> String toJson(T t) {
        try {
            return OBJECT_MAPPER_INSTANCE.writer().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static Module createTableStoreJacksonModule() {
        SimpleModule module = new SimpleModule("Table store");
        JsonSerdeUtil.registerJsonObjects(module, TableSchema.class, SchemaSerializer.INSTANCE);
        JsonSerdeUtil.registerJsonObjects(module, DataField.class, DataFieldSerializer.INSTANCE);
        return module;
    }

    private static <T> void registerJsonObjects(SimpleModule module, Class<T> clazz, final JsonSerializer<T> serializer) {
        module.addSerializer((org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer)new StdSerializer<T>(clazz){

            public void serialize(T t, JsonGenerator generator, SerializerProvider provider) throws IOException {
                serializer.serialize(t, generator);
            }
        });
        module.addDeserializer(clazz, (JsonDeserializer)new StdDeserializer<T>(clazz){

            public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                return serializer.deserialize((JsonNode)parser.readValueAsTree());
            }
        });
    }

    private JsonSerdeUtil() {
    }

    static {
        OBJECT_MAPPER_INSTANCE.registerModule(JsonSerdeUtil.createTableStoreJacksonModule());
    }
}

