/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.table.store.file.utils.AtomicFsDataOutputStream;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.RecoverableAtomicFileWriter;
import org.apache.flink.table.store.file.utils.RenamingAtomicFsDataOutputStream;

public interface AtomicFileWriter {
    public AtomicFsDataOutputStream open(Path var1) throws IOException;

    public static AtomicFileWriter create(FileSystem fs) throws IOException {
        RecoverableWriter recoverableWriter = null;
        try {
            recoverableWriter = fs.createRecoverableWriter();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (recoverableWriter == null || fs.getKind() == FileSystemKind.FILE_SYSTEM) {
            return path -> new RenamingAtomicFsDataOutputStream(path.getFileSystem(), path, new Path(path.getParent(), "." + path.getName() + UUID.randomUUID()));
        }
        return new RecoverableAtomicFileWriter(recoverableWriter);
    }

    public static boolean writeFileUtf8(Path path, String content) throws IOException {
        return AtomicFileWriter.writeFileUtf8(AtomicFileWriter.create(path.getFileSystem()), path, content);
    }

    @VisibleForTesting
    public static boolean writeFileUtf8(AtomicFileWriter writer, Path path, String content) throws IOException {
        AtomicFsDataOutputStream out = writer.open(path);
        try {
            FileUtils.writeOutputStreamUtf8(out, content);
            return out.closeAndCommit();
        }
        catch (IOException e) {
            out.close();
            throw e;
        }
    }
}

