/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.Map;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitReader;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitState;
import org.apache.flink.table.store.table.source.TableRead;

public final class FileStoreSourceReader
extends SingleThreadMultiplexSourceReaderBase<RecordAndPosition<RowData>, RowData, FileStoreSourceSplit, FileStoreSourceSplitState> {
    public FileStoreSourceReader(SourceReaderContext readerContext, TableRead tableRead) {
        super(() -> new FileStoreSourceSplitReader(tableRead), (element, output, splitState) -> {
            output.collect(element.getRecord());
            splitState.setPosition((RecordAndPosition<RowData>)element);
        }, readerContext.getConfiguration(), readerContext);
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.context.sendSplitRequest();
        }
    }

    protected void onSplitFinished(Map<String, FileStoreSourceSplitState> finishedSplitIds) {
        this.context.sendSplitRequest();
    }

    protected FileStoreSourceSplitState initializedState(FileStoreSourceSplit split) {
        return new FileStoreSourceSplitState(split);
    }

    protected FileStoreSourceSplit toSplitType(String splitId, FileStoreSourceSplitState splitState) {
        return splitState.toSourceSplit();
    }
}

