/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.mddocgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.maven.osgicheck.impl.mddocgen.AbstractMarkdownMojo;
import org.apache.felix.maven.osgicheck.impl.mddocgen.ClassName;
import org.apache.felix.metatype.AD;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.OCD;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="generate-metatype-doc", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=false)
public final class MetatypeMarkdownGeneratorMojo
extends AbstractMarkdownMojo {
    private static final String[] TYPES = new String[]{null, "String", "Long", "Integer", "Short", "Character", "Byte", "Double", "Float", "BigInteger", "BigDecimal", "Boolean", "Password"};
    private final MetaDataReader reader = new MetaDataReader();
    @Parameter(defaultValue="")
    private String locale;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File metatypeDirectory;
    @Parameter(defaultValue="${project.build.directory}/mddoc/metatype/${project.artifactId}/${project.version}")
    private File metatypeMarkdownDirectory;
    @Parameter(defaultValue="${project.name} ${project.version} Metatypes", readonly=true)
    private String readmeTitle;

    @Override
    protected String getReadmeTitle() {
        return this.readmeTitle;
    }

    @Override
    protected File getSourceDir() {
        return this.metatypeDirectory;
    }

    @Override
    protected File getTargetDir() {
        return this.metatypeMarkdownDirectory;
    }

    @Override
    protected String getIncludes() {
        return "**/OSGI-INF/metatype/*.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Collection<File> metatypes) {
        for (File metatypeFile : metatypes) {
            MetaData metaData = this.readMetaData(metatypeFile);
            if (metaData == null) continue;
            Properties localizationProperties = this.readLocalizationProperties(metatypeFile, metaData);
            Map ocds = metaData.getObjectClassDefinitions();
            for (OCD ocd : ocds.values()) {
                String id = ocd.getID();
                if (this.isExcluded(id)) continue;
                ClassName className = ClassName.get(id);
                this.doIndex(className.getPackageName(), className);
                File targetDir = new File(this.metatypeMarkdownDirectory, className.getPackagePath());
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                File targetFile = new File(targetDir, className.getSimpleName() + ".md");
                PrintWriter writer = null;
                try {
                    writer = MetatypeMarkdownGeneratorMojo.newPrintWriter(targetFile);
                    writer.format("# %s%n%n", MetatypeMarkdownGeneratorMojo.getlocalizedLabel(ocd.getName(), localizationProperties));
                    writer.format("## `%s`%n%n", id);
                    writer.println(MetatypeMarkdownGeneratorMojo.getlocalizedLabel(ocd.getDescription(), localizationProperties));
                    writer.println();
                    writer.println("| ID  | Name | Required | Type | Default value | Description |");
                    writer.println("| --- | ---- | -------- | ---- | ------------- | ----------- |");
                    Map attributes = ocd.getAttributeDefinitions();
                    MetatypeMarkdownGeneratorMojo.printAttributes(attributes, localizationProperties, writer);
                    Map optionalAttributes = ocd.getOptionalAttributes();
                    MetatypeMarkdownGeneratorMojo.printAttributes(optionalAttributes, localizationProperties, writer);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("An error occurred while rendering documentation in " + targetFile), (Throwable)e);
                }
                finally {
                    IOUtil.close((Writer)writer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaData readMetaData(File metatypeFile) {
        this.getLog().debug((CharSequence)("Analyzing '" + metatypeFile + "' meta type file..."));
        FileInputStream inputStream = null;
        MetaData metadata = null;
        try {
            inputStream = new FileInputStream(metatypeFile);
            metadata = this.reader.parse((InputStream)inputStream);
            this.getLog().debug((CharSequence)("Metaype file '" + metatypeFile + "' successfully load"));
        }
        catch (Exception e) {
            try {
                this.getLog().error((CharSequence)("Metatype file '" + metatypeFile + "' could not be read"), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
            IOUtil.close((InputStream)inputStream);
        }
        IOUtil.close((InputStream)inputStream);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readLocalizationProperties(File metatypeFile, MetaData metaData) {
        Properties properties;
        block5: {
            File propertiesFile;
            block6: {
                StringBuilder propertiesFileName = new StringBuilder(metaData.getLocalePrefix());
                if (this.locale != null && !this.locale.isEmpty()) {
                    propertiesFileName.append('_').append(this.locale);
                }
                propertiesFileName.append(".properties");
                File mainDir = metatypeFile.getParentFile().getParentFile().getParentFile();
                propertiesFile = FileUtils.resolveFile((File)mainDir, (String)propertiesFileName.toString());
                properties = new Properties();
                FileInputStream inputStream = null;
                if (!propertiesFile.exists()) break block6;
                this.getLog().debug((CharSequence)("Loading properties file '" + propertiesFile + "'..."));
                try {
                    inputStream = new FileInputStream(propertiesFile);
                    properties.load(inputStream);
                    this.getLog().debug((CharSequence)("Properties file '" + propertiesFile + "' successfully load"));
                }
                catch (IOException e) {
                    try {
                        this.getLog().error((CharSequence)("Properties file '" + metatypeFile + "' can not be read, labels could not be human-readable"), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(inputStream);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)inputStream);
                    break block5;
                }
                IOUtil.close((InputStream)inputStream);
                break block5;
            }
            this.getLog().warn((CharSequence)("File '" + propertiesFile + "' for '" + metatypeFile + "' does not exist, labels could not be human-readable"));
        }
        return properties;
    }

    private static String getlocalizedLabel(String originalKey, Properties properties) {
        String key;
        if (originalKey != null && originalKey.startsWith("%") && properties.containsKey(key = originalKey.substring(1))) {
            return properties.getProperty(key);
        }
        return originalKey;
    }

    private static void printAttributes(Map<String, AD> attributes, Properties properties, PrintWriter writer) {
        if (attributes != null && !attributes.isEmpty()) {
            for (AD attribute : attributes.values()) {
                writer.format("| %s | %s | `%s` | `%s` | `%s` | %s |%n", attribute.getID(), MetatypeMarkdownGeneratorMojo.getlocalizedLabel(attribute.getName(), properties), attribute.isRequired(), TYPES[attribute.getType()], Arrays.toString(attribute.getDefaultValue()), MetatypeMarkdownGeneratorMojo.getlocalizedLabel(attribute.getDescription(), properties));
            }
        }
    }
}

