/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.jaas.internal.Util;

enum ControlFlag {
    REQUIRED(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED),
    REQUISITE(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE),
    SUFFICIENT(AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT),
    OPTIONAL(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL);

    private final AppConfigurationEntry.LoginModuleControlFlag flag;

    private ControlFlag(AppConfigurationEntry.LoginModuleControlFlag flag) {
        this.flag = flag;
    }

    public AppConfigurationEntry.LoginModuleControlFlag flag() {
        return this.flag;
    }

    public static ControlFlag from(String val) {
        if ((val = Util.trimToNull(val)) == null) {
            return REQUIRED;
        }
        val = val.toUpperCase();
        return ControlFlag.valueOf(val);
    }

    public static String toString(AppConfigurationEntry.LoginModuleControlFlag flag) {
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
            return "REQUIRED";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
            return "REQUISITE";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
            return "SUFFICIENT";
        }
        if (flag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
            return "OPTIONAL";
        }
        throw new IllegalArgumentException("Unknown flag " + flag);
    }
}

