/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.impl;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.OSGiTestSuite;
import org.apache.felix.ipojo.junit4osgi.impl.ResultPrinter;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class JunitExtender
implements OSGiJunitRunner,
Pojo {
    private InstanceManager __IM;
    public static final String SUITE_METHODNAME = "suite";
    private boolean __Fm_suites;
    private Map m_suites;
    private boolean __Fm_printer;
    private ResultPrinter m_printer;
    private boolean __Fm_log;
    private LogService m_log;
    private boolean __MonBundleArrival$org_osgi_framework_Bundle$java_lang_String;
    private boolean __MaddTestSuite$org_osgi_framework_Bundle$java_lang_Class;
    private boolean __MremoveTestSuites$org_osgi_framework_Bundle;
    private boolean __MonBundleDeparture$org_osgi_framework_Bundle;
    private boolean __MsetResultPrinter$java_io_PrintStream;
    private boolean __Mrun;
    private boolean __MdoRun$junit_framework_Test;
    private boolean __McreateTestFromClass$java_lang_Class$org_osgi_framework_Bundle;
    private boolean __MgetTests;
    private boolean __Mrun$junit_framework_Test;
    private boolean __MgetTests$long;
    private boolean __Mrun$long;
    private boolean __Mstopping;
    private boolean __Mstarting;
    private boolean __MgetBundleContext$org_osgi_framework_Bundle;

    Map __getm_suites() {
        if (!this.__Fm_suites) {
            return this.m_suites;
        }
        return (Map)this.__IM.onGet((Object)this, "m_suites");
    }

    void __setm_suites(Map map) {
        if (!this.__Fm_suites) {
            this.m_suites = map;
            return;
        }
        this.__IM.onSet((Object)this, "m_suites", (Object)map);
    }

    ResultPrinter __getm_printer() {
        if (!this.__Fm_printer) {
            return this.m_printer;
        }
        return (ResultPrinter)this.__IM.onGet((Object)this, "m_printer");
    }

    void __setm_printer(ResultPrinter resultPrinter) {
        if (!this.__Fm_printer) {
            this.m_printer = resultPrinter;
            return;
        }
        this.__IM.onSet((Object)this, "m_printer", (Object)resultPrinter);
    }

    LogService __getm_log() {
        if (!this.__Fm_log) {
            return this.m_log;
        }
        return (LogService)this.__IM.onGet((Object)this, "m_log");
    }

    void __setm_log(LogService logService) {
        if (!this.__Fm_log) {
            this.m_log = logService;
            return;
        }
        this.__IM.onSet((Object)this, "m_log", (Object)logService);
    }

    public JunitExtender() {
        this(null);
    }

    private JunitExtender(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_suites(new HashMap());
        this.__setm_printer(new ResultPrinter(System.out));
    }

    void onBundleArrival(Bundle bundle, String string) {
        if (!this.__MonBundleArrival$org_osgi_framework_Bundle$java_lang_String) {
            this.__onBundleArrival(bundle, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onBundleArrival$org_osgi_framework_Bundle$java_lang_String", new Object[]{bundle, string});
            this.__onBundleArrival(bundle, string);
            this.__IM.onExit((Object)this, "onBundleArrival$org_osgi_framework_Bundle$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onBundleArrival$org_osgi_framework_Bundle$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __onBundleArrival(Bundle bundle, String header) {
        String[] tss = ParseUtils.split((String)header, (String)",");
        for (int i = 0; i < tss.length; ++i) {
            try {
                if (tss[i].length() == 0) continue;
                this.__getm_log().log(3, "Loading " + tss[i]);
                Class clazz = bundle.loadClass(tss[i].trim());
                this.addTestSuite(bundle, clazz);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.__getm_log().log(1, "The test suite " + tss[i] + " is not in the bundle " + bundle.getBundleId() + " : " + e.getMessage());
            }
        }
    }

    private synchronized void addTestSuite(Bundle bundle, Class clazz) {
        if (!this.__MaddTestSuite$org_osgi_framework_Bundle$java_lang_Class) {
            this.__addTestSuite(bundle, clazz);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addTestSuite$org_osgi_framework_Bundle$java_lang_Class", new Object[]{bundle, clazz});
            this.__addTestSuite(bundle, clazz);
            this.__IM.onExit((Object)this, "addTestSuite$org_osgi_framework_Bundle$java_lang_Class", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addTestSuite$org_osgi_framework_Bundle$java_lang_Class", throwable);
            throw throwable;
        }
    }

    private void __addTestSuite(Bundle bundle, Class test) {
        ArrayList<Class> list = (ArrayList<Class>)this.__getm_suites().get(bundle);
        if (list == null) {
            list = new ArrayList<Class>();
            list.add(test);
            this.__getm_suites().put(bundle, list);
        } else {
            list.add(test);
        }
    }

    private synchronized void removeTestSuites(Bundle bundle) {
        if (!this.__MremoveTestSuites$org_osgi_framework_Bundle) {
            this.__removeTestSuites(bundle);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeTestSuites$org_osgi_framework_Bundle", new Object[]{bundle});
            this.__removeTestSuites(bundle);
            this.__IM.onExit((Object)this, "removeTestSuites$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeTestSuites$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __removeTestSuites(Bundle bundle) {
        List list = (List)this.__getm_suites().remove(bundle);
        this.__getm_log().log(3, "Unload test suites " + list);
    }

    void onBundleDeparture(Bundle bundle) {
        if (!this.__MonBundleDeparture$org_osgi_framework_Bundle) {
            this.__onBundleDeparture(bundle);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onBundleDeparture$org_osgi_framework_Bundle", new Object[]{bundle});
            this.__onBundleDeparture(bundle);
            this.__IM.onExit((Object)this, "onBundleDeparture$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onBundleDeparture$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __onBundleDeparture(Bundle bundle) {
        this.removeTestSuites(bundle);
    }

    public void setResultPrinter(PrintStream printStream) {
        if (!this.__MsetResultPrinter$java_io_PrintStream) {
            this.__setResultPrinter(printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setResultPrinter$java_io_PrintStream", new Object[]{printStream});
            this.__setResultPrinter(printStream);
            this.__IM.onExit((Object)this, "setResultPrinter$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setResultPrinter$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __setResultPrinter(PrintStream pw) {
        this.__setm_printer(new ResultPrinter(pw));
    }

    public synchronized List run() {
        List list;
        if (!this.__Mrun) {
            return this.__run();
        }
        try {
            this.__IM.onEntry((Object)this, "run", new Object[0]);
            list = this.__run();
            this.__IM.onExit((Object)this, "run", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "run", throwable);
            throw throwable;
        }
        return list;
    }

    private List __run() {
        ArrayList<TestResult> results = new ArrayList<TestResult>(this.__getm_suites().size());
        Iterator it = this.__getm_suites().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            List list = (List)this.__getm_suites().get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                TestResult tr = this.doRun(test);
                results.add(tr);
            }
        }
        return results;
    }

    private TestResult doRun(Test test) {
        TestResult testResult;
        if (!this.__MdoRun$junit_framework_Test) {
            return this.__doRun(test);
        }
        try {
            this.__IM.onEntry((Object)this, "doRun$junit_framework_Test", new Object[]{test});
            testResult = this.__doRun(test);
            this.__IM.onExit((Object)this, "doRun$junit_framework_Test", (Object)testResult);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doRun$junit_framework_Test", throwable);
            throw throwable;
        }
        return testResult;
    }

    private TestResult __doRun(Test test) {
        TestResult result = new TestResult();
        result.addListener(this.__getm_printer());
        long startTime = System.currentTimeMillis();
        test.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.__getm_printer().print(result, runTime);
        return result;
    }

    private Test createTestFromClass(Class clazz, Bundle bundle) {
        Test test;
        if (!this.__McreateTestFromClass$java_lang_Class$org_osgi_framework_Bundle) {
            return this.__createTestFromClass(clazz, bundle);
        }
        try {
            this.__IM.onEntry((Object)this, "createTestFromClass$java_lang_Class$org_osgi_framework_Bundle", new Object[]{clazz, bundle});
            test = this.__createTestFromClass(clazz, bundle);
            this.__IM.onExit((Object)this, "createTestFromClass$java_lang_Class$org_osgi_framework_Bundle", (Object)test);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createTestFromClass$java_lang_Class$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
        return test;
    }

    private Test __createTestFromClass(Class clazz, Bundle bundle) {
        Method suiteMethod = null;
        boolean bc = false;
        try {
            suiteMethod = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            try {
                suiteMethod = clazz.getMethod(SUITE_METHODNAME, BundleContext.class);
                bc = true;
            }
            catch (Exception e2) {
                if (OSGiTestSuite.class.isAssignableFrom(clazz)) {
                    OSGiTestSuite ts = new OSGiTestSuite(clazz, this.getBundleContext(bundle));
                    return ts;
                }
                if (OSGiTestCase.class.isAssignableFrom(clazz)) {
                    OSGiTestSuite ts = new OSGiTestSuite(clazz, this.getBundleContext(bundle));
                    return ts;
                }
                return new TestSuite(clazz);
            }
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            this.__getm_log().log(1, "Suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = bc ? (Test)suiteMethod.invoke(null, this.getBundleContext(bundle)) : (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            this.__getm_log().log(1, "Failed to invoke suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.__getm_log().log(1, "Failed to invoke suite():" + e.toString());
            return null;
        }
        return test;
    }

    public synchronized List getTests() {
        List list;
        if (!this.__MgetTests) {
            return this.__getTests();
        }
        try {
            this.__IM.onEntry((Object)this, "getTests", new Object[0]);
            list = this.__getTests();
            this.__IM.onExit((Object)this, "getTests", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTests", throwable);
            throw throwable;
        }
        return list;
    }

    private List __getTests() {
        ArrayList<Test> results = new ArrayList<Test>();
        Iterator it = this.__getm_suites().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            List list = (List)this.__getm_suites().get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                results.add(test);
            }
        }
        return results;
    }

    public TestResult run(Test test) {
        TestResult testResult;
        if (!this.__Mrun$junit_framework_Test) {
            return this.__run(test);
        }
        try {
            this.__IM.onEntry((Object)this, "run$junit_framework_Test", new Object[]{test});
            testResult = this.__run(test);
            this.__IM.onExit((Object)this, "run$junit_framework_Test", (Object)testResult);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "run$junit_framework_Test", throwable);
            throw throwable;
        }
        return testResult;
    }

    private TestResult __run(Test test) {
        return this.doRun(test);
    }

    public synchronized List getTests(long l) {
        List list;
        if (!this.__MgetTests$long) {
            return this.__getTests(l);
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(l);
            this.__IM.onEntry((Object)this, "getTests$long", objectArray);
            list = this.__getTests(l);
            this.__IM.onExit((Object)this, "getTests$long", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTests$long", throwable);
            throw throwable;
        }
        return list;
    }

    private List __getTests(long bundleId) {
        Iterator it = this.__getm_suites().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            if (bundle.getBundleId() != bundleId) continue;
            ArrayList<Test> results = new ArrayList<Test>();
            List list = (List)this.__getm_suites().get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                results.add(test);
            }
            return results;
        }
        return null;
    }

    public synchronized List run(long l) {
        List list;
        if (!this.__Mrun$long) {
            return this.__run(l);
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(l);
            this.__IM.onEntry((Object)this, "run$long", objectArray);
            list = this.__run(l);
            this.__IM.onExit((Object)this, "run$long", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "run$long", throwable);
            throw throwable;
        }
        return list;
    }

    private List __run(long bundleId) {
        Iterator it = this.__getm_suites().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Bundle bundle = (Bundle)entry.getKey();
            if (bundle.getBundleId() != bundleId) continue;
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            List list = (List)this.__getm_suites().get(bundle);
            for (int i = 0; i < list.size(); ++i) {
                Test test = this.createTestFromClass((Class)list.get(i), bundle);
                TestResult tr = this.doRun(test);
                results.add(tr);
            }
            return results;
        }
        return null;
    }

    public synchronized void stopping() {
        if (!this.__Mstopping) {
            this.__stopping();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopping", new Object[0]);
            this.__stopping();
            this.__IM.onExit((Object)this, "stopping", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopping", throwable);
            throw throwable;
        }
    }

    private void __stopping() {
        this.__getm_log().log(3, "Cleaning test suites ...");
        this.__getm_suites().clear();
    }

    public void starting() {
        if (!this.__Mstarting) {
            this.__starting();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "starting", new Object[0]);
            this.__starting();
            this.__IM.onExit((Object)this, "starting", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "starting", throwable);
            throw throwable;
        }
    }

    private void __starting() {
        this.__getm_log().log(3, "Junit Extender starting ...");
    }

    private BundleContext getBundleContext(Bundle bundle) {
        BundleContext bundleContext;
        if (!this.__MgetBundleContext$org_osgi_framework_Bundle) {
            return this.__getBundleContext(bundle);
        }
        try {
            this.__IM.onEntry((Object)this, "getBundleContext$org_osgi_framework_Bundle", new Object[]{bundle});
            bundleContext = this.__getBundleContext(bundle);
            this.__IM.onExit((Object)this, "getBundleContext$org_osgi_framework_Bundle", (Object)bundleContext);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBundleContext$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
        return bundleContext;
    }

    private BundleContext __getBundleContext(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Method meth = null;
        try {
            meth = bundle.getClass().getMethod("getBundleContext", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (meth == null) {
            try {
                meth = bundle.getClass().getMethod("getContext", new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (meth != null) {
            if (!meth.isAccessible()) {
                meth.setAccessible(true);
            }
            try {
                return (BundleContext)meth.invoke((Object)bundle, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.__getm_log().log(1, "Cannot get the BundleContext by invoking " + meth.getName(), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.__getm_log().log(1, "Cannot get the BundleContext by invoking " + meth.getName(), (Throwable)e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.__getm_log().log(1, "Cannot get the BundleContext by invoking " + meth.getName(), (Throwable)e);
                return null;
            }
        }
        Field[] fields = bundle.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!(class$org$osgi$framework$BundleContext == null ? JunitExtender.class$("org.osgi.framework.BundleContext") : class$org$osgi$framework$BundleContext).isAssignableFrom(fields[i].getType())) continue;
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            try {
                return (BundleContext)fields[i].get(bundle);
            }
            catch (IllegalArgumentException e) {
                this.__getm_log().log(1, "Cannot get the BundleContext by reflecting on " + fields[i].getName(), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.__getm_log().log(1, "Cannot get the BundleContext by reflecting on " + fields[i].getName(), (Throwable)e);
                return null;
            }
        }
        this.__getm_log().log(1, "Cannot find the BundleContext for " + bundle.getSymbolicName(), null);
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_suites")) {
                this.__Fm_suites = true;
            }
            if (set.contains("m_printer")) {
                this.__Fm_printer = true;
            }
            if (set.contains("m_log")) {
                this.__Fm_log = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("onBundleArrival$org_osgi_framework_Bundle$java_lang_String")) {
                this.__MonBundleArrival$org_osgi_framework_Bundle$java_lang_String = true;
            }
            if (set.contains("addTestSuite$org_osgi_framework_Bundle$java_lang_Class")) {
                this.__MaddTestSuite$org_osgi_framework_Bundle$java_lang_Class = true;
            }
            if (set.contains("removeTestSuites$org_osgi_framework_Bundle")) {
                this.__MremoveTestSuites$org_osgi_framework_Bundle = true;
            }
            if (set.contains("onBundleDeparture$org_osgi_framework_Bundle")) {
                this.__MonBundleDeparture$org_osgi_framework_Bundle = true;
            }
            if (set.contains("setResultPrinter$java_io_PrintStream")) {
                this.__MsetResultPrinter$java_io_PrintStream = true;
            }
            if (set.contains("run")) {
                this.__Mrun = true;
            }
            if (set.contains("doRun$junit_framework_Test")) {
                this.__MdoRun$junit_framework_Test = true;
            }
            if (set.contains("createTestFromClass$java_lang_Class$org_osgi_framework_Bundle")) {
                this.__McreateTestFromClass$java_lang_Class$org_osgi_framework_Bundle = true;
            }
            if (set.contains("getTests")) {
                this.__MgetTests = true;
            }
            if (set.contains("run$junit_framework_Test")) {
                this.__Mrun$junit_framework_Test = true;
            }
            if (set.contains("getTests$long")) {
                this.__MgetTests$long = true;
            }
            if (set.contains("run$long")) {
                this.__Mrun$long = true;
            }
            if (set.contains("stopping")) {
                this.__Mstopping = true;
            }
            if (set.contains("starting")) {
                this.__Mstarting = true;
            }
            if (set.contains("getBundleContext$org_osgi_framework_Bundle")) {
                this.__MgetBundleContext$org_osgi_framework_Bundle = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

