/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.io.IO;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.sed.Replacer;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Macro
implements Replacer {
    Processor domain;
    Object[] targets;
    boolean flattening;
    static Pattern commands = Pattern.compile("(?<!\\\\);");
    static String _uniqHelp = "${uniq;<list> ...}";
    static String _filterHelp = "${%s;<list>;<regex>}";
    static String _sortHelp = "${sort;<list>...}";
    static String _joinHelp = "${join;<list>...}";
    static String _ifHelp = "${if;<condition>;<iftrue> [;<iffalse>] }";
    public static String _fmodifiedHelp = "${fmodified;<list of filenames>...}, return latest modification date";
    static String _toclassnameHelp = "${classname;<list of class names>}, convert class paths to FQN class names ";
    static String _toclasspathHelp = "${toclasspath;<list>[;boolean]}, convert a list of class names to paths";
    static final String MASK_STRING = "[\\-+=~0123456789]{0,3}[=~]?";
    static final Pattern MASK = Pattern.compile("[\\-+=~0123456789]{0,3}[=~]?");
    static final String _versionHelp = "${version;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final Pattern[] _versionPattern;
    static Pattern RANGE_MASK;
    static String _rangeHelp;
    static Pattern[] _rangePattern;
    public static String _fileHelp;

    static {
        Pattern[] patternArray = new Pattern[4];
        patternArray[2] = MASK;
        patternArray[3] = Verifier.VERSION;
        _versionPattern = patternArray;
        RANGE_MASK = Pattern.compile("(\\[|\\()([\\-+=~0123456789]{0,3}[=~]?),([\\-+=~0123456789]{0,3}[=~]?)(\\]|\\))");
        _rangeHelp = "${range;<mask>[;<version>]}, range for version, if version not specified lookyp ${@}\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
        Pattern[] patternArray2 = new Pattern[2];
        patternArray2[1] = RANGE_MASK;
        _rangePattern = patternArray2;
        _fileHelp = "${file;<base>;<paths>...}, create correct OS dependent path";
    }

    public Macro(Processor domain, Object ... targets) {
        this.domain = domain;
        this.targets = targets;
        if (targets != null) {
            Object[] objectArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                assert (o != null);
                ++n2;
            }
        }
    }

    public String process(String line, Processor source) {
        return this.process(line, new Link(source, null, line));
    }

    String process(String line, Link link) {
        StringBuffer sb = new StringBuffer();
        this.process(line, 0, '\u0000', '\u0000', sb, link);
        return sb.toString();
    }

    int process(CharSequence org, int index, char begin, char end, StringBuffer result, Link link) {
        StringBuilder line = new StringBuilder(org);
        int nesting = 1;
        StringBuffer variable = new StringBuffer();
        while (index < line.length()) {
            char c1;
            if ((c1 = line.charAt(index++)) == end) {
                if (--nesting == 0) {
                    result.append(this.replace(variable.toString(), link));
                    return index;
                }
            } else if (c1 == begin) {
                ++nesting;
            } else {
                char c2;
                char terminator;
                if (c1 == '\\' && index < line.length() - 1 && line.charAt(index) == '$') {
                    ++index;
                    variable.append('$');
                    continue;
                }
                if (c1 == '$' && index < line.length() - 2 && (terminator = Macro.getTerminator(c2 = line.charAt(index))) != '\u0000') {
                    index = this.process(line, index + 1, c2, terminator, variable, link);
                    continue;
                }
            }
            variable.append(c1);
        }
        result.append(variable);
        return index;
    }

    public static char getTerminator(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u2039': {
                return '\u203a';
            }
        }
        return '\u0000';
    }

    protected String replace(String key, Link link) {
        if (link != null && link.contains(key)) {
            return "${infinite:" + link.toString() + "}";
        }
        if (key != null) {
            if ((key = key.trim()).length() > 0) {
                Processor source = this.domain;
                String value = null;
                while (source != null) {
                    value = source.getProperties().getProperty(key);
                    if (value != null) break;
                    source = source.getParent();
                }
                if (value != null) {
                    return this.process(value, new Link(source, link, key));
                }
                value = this.doCommands(key, link);
                if (value != null) {
                    return this.process(value, new Link(source, link, key));
                }
                if (key != null && key.trim().length() > 0 && (value = System.getProperty(key)) != null) {
                    return value;
                }
                if (!this.flattening) {
                    this.domain.warning("No translation found for macro: " + key, new Object[0]);
                }
            } else {
                this.domain.warning("Found empty macro key", new Object[0]);
            }
        } else {
            this.domain.warning("Found null macro key", new Object[0]);
        }
        return "${" + key + "}";
    }

    private String doCommands(String key, Link source) {
        String[] args = commands.split(key);
        if (args == null || args.length == 0) {
            return null;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].indexOf(92) >= 0) {
                args[i] = args[i].replaceAll("\\\\;", ";");
            }
            ++i;
        }
        if (args[0].startsWith("^")) {
            String varname = args[0].substring(1).trim();
            Processor parent = source.start.getParent();
            if (parent != null) {
                return parent.getProperty(varname);
            }
            return null;
        }
        Processor rover = this.domain;
        while (rover != null) {
            String result = this.doCommand(rover, args[0], args);
            if (result != null) {
                return result;
            }
            rover = rover.getParent();
        }
        int i2 = 0;
        while (this.targets != null && i2 < this.targets.length) {
            String result = this.doCommand(this.targets[i2], args[0], args);
            if (result != null) {
                return result;
            }
            ++i2;
        }
        return this.doCommand(this, args[0], args);
    }

    private String doCommand(Object target, String method, String[] args) {
        if (target != null) {
            String cname = "_" + method.replaceAll("-", "_");
            try {
                Method m = target.getClass().getMethod(cname, String[].class);
                return (String)m.invoke(target, new Object[]{args});
            }
            catch (NoSuchMethodException m) {
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    this.domain.error("%s, for cmd: %s, arguments; %s", e.getMessage(), method, Arrays.toString(args));
                } else {
                    this.domain.warning("Exception in replace: " + e.getCause(), new Object[0]);
                    e.getCause().printStackTrace();
                }
            }
            catch (Exception e) {
                this.domain.warning("Exception in replace: " + e + " method=" + method, new Object[0]);
                e.printStackTrace();
            }
        }
        return null;
    }

    public String _uniq(String[] args) {
        Macro.verifyCommand(args, _uniqHelp, null, 1, Integer.MAX_VALUE);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int i = 1;
        while (i < args.length) {
            Processor.split(args[i], set);
            ++i;
        }
        return Processor.join(set, ",");
    }

    public String _pathseparator(String[] args) {
        return File.pathSeparator;
    }

    public String _separator(String[] args) {
        return File.separator;
    }

    public String _filter(String[] args) {
        return this.filter(args, false);
    }

    public String _filterout(String[] args) {
        return this.filter(args, true);
    }

    String filter(String[] args, boolean include) {
        Macro.verifyCommand(args, String.format(_filterHelp, args[0]), null, 3, 3);
        ArrayList<String> list = new ArrayList<String>(Processor.split(args[1]));
        Pattern pattern = Pattern.compile(args[2]);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (pattern.matcher((CharSequence)i.next()).matches() != include) continue;
            i.remove();
        }
        return Processor.join(list);
    }

    public String _sort(String[] args) {
        Macro.verifyCommand(args, _sortHelp, null, 2, Integer.MAX_VALUE);
        ArrayList<String> result = new ArrayList<String>();
        int i = 1;
        while (i < args.length) {
            Processor.split(args[i], result);
            ++i;
        }
        Collections.sort(result);
        return Processor.join(result);
    }

    public String _join(String[] args) {
        Macro.verifyCommand(args, _joinHelp, null, 1, Integer.MAX_VALUE);
        ArrayList<String> result = new ArrayList<String>();
        int i = 1;
        while (i < args.length) {
            Processor.split(args[i], result);
            ++i;
        }
        return Processor.join(result);
    }

    public String _if(String[] args) {
        Macro.verifyCommand(args, _ifHelp, null, 3, 4);
        String condition = args[1].trim();
        if (condition.length() != 0) {
            return args[2];
        }
        if (args.length > 3) {
            return args[3];
        }
        return "";
    }

    public String _now(String[] args) {
        return ((Object)new Date()).toString();
    }

    public String _fmodified(String[] args) throws Exception {
        Macro.verifyCommand(args, _fmodifiedHelp, null, 2, Integer.MAX_VALUE);
        long time = 0L;
        ArrayList<String> names = new ArrayList<String>();
        int i = 1;
        while (i < args.length) {
            Processor.split(args[i], names);
            ++i;
        }
        for (String name : names) {
            File f = new File(name);
            if (!f.exists() || f.lastModified() <= time) continue;
            time = f.lastModified();
        }
        return "" + time;
    }

    public String _long2date(String[] args) {
        try {
            return ((Object)new Date(Long.parseLong(args[1]))).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "not a valid long";
        }
    }

    public String _literal(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${literal;<value>} macro");
        }
        return "${" + args[1] + "}";
    }

    public String _def(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${def;<value>} macro");
        }
        return this.domain.getProperty(args[1], "");
    }

    public String _replace(String[] args) {
        if (args.length != 4) {
            this.domain.warning("Invalid nr of arguments to replace " + Arrays.asList(args), new Object[0]);
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        int i = 0;
        while (i < list.length) {
            String element = list[i].trim();
            if (!element.equals("")) {
                sb.append(del);
                sb.append(element.replaceAll(args[2], args[3]));
                del = ", ";
            }
            ++i;
        }
        return sb.toString();
    }

    public String _warning(String[] args) {
        int i = 1;
        while (i < args.length) {
            this.domain.warning(this.process(args[i]), new Object[0]);
            ++i;
        }
        return "";
    }

    public String _error(String[] args) {
        int i = 1;
        while (i < args.length) {
            this.domain.error(this.process(args[i]), new Object[0]);
            ++i;
        }
        return "";
    }

    public String _toclassname(String[] args) {
        Macro.verifyCommand(args, _toclassnameHelp, null, 2, 2);
        Collection<String> paths = Processor.split(args[1]);
        ArrayList<String> names = new ArrayList<String>(paths.size());
        for (String path : paths) {
            String name;
            if (path.endsWith(".class")) {
                name = path.substring(0, path.length() - 6).replace('/', '.');
                names.add(name);
                continue;
            }
            if (path.endsWith(".java")) {
                name = path.substring(0, path.length() - 5).replace('/', '.');
                names.add(name);
                continue;
            }
            this.domain.warning("in toclassname, " + args[1] + " is not a class path because it does not end in .class", new Object[0]);
        }
        return Processor.join(names, ",");
    }

    public String _toclasspath(String[] args) {
        Macro.verifyCommand(args, _toclasspathHelp, null, 2, 3);
        boolean cl = true;
        if (args.length > 2) {
            cl = new Boolean(args[2]);
        }
        Collection<String> names = Processor.split(args[1]);
        ArrayList<String> paths = new ArrayList<String>(names.size());
        for (String name : names) {
            String path = String.valueOf(name.replace('.', '/')) + (cl ? ".class" : "");
            paths.add(path);
        }
        return Processor.join(paths, ",");
    }

    public String _dir(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${dir;...}", new Object[0]);
            return null;
        }
        String del = "";
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < args.length) {
            File f = this.domain.getFile(args[i]);
            if (f.exists() && f.getParentFile().exists()) {
                sb.append(del);
                sb.append(f.getParentFile().getAbsolutePath());
                del = ",";
            }
            ++i;
        }
        return sb.toString();
    }

    public String _basename(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${basename;...}", new Object[0]);
            return null;
        }
        String del = "";
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < args.length) {
            File f = this.domain.getFile(args[i]);
            if (f.exists() && f.getParentFile().exists()) {
                sb.append(del);
                sb.append(f.getName());
                del = ",";
            }
            ++i;
        }
        return sb.toString();
    }

    public String _isfile(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${isfile;...}", new Object[0]);
            return null;
        }
        boolean isfile = true;
        int i = 1;
        while (i < args.length) {
            File f = new File(args[i]).getAbsoluteFile();
            isfile &= f.isFile();
            ++i;
        }
        return isfile ? "true" : "false";
    }

    public String _isdir(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${isdir;...}", new Object[0]);
            return null;
        }
        boolean isdir = true;
        int i = 1;
        while (i < args.length) {
            File f = new File(args[i]).getAbsoluteFile();
            isdir &= f.isDirectory();
            ++i;
        }
        return isdir ? "true" : "false";
    }

    public String _tstamp(String[] args) {
        String format = "yyyyMMddHHmm";
        long now = System.currentTimeMillis();
        if (args.length > 1) {
            format = args[1];
            if (args.length > 2) {
                now = Long.parseLong(args[2]);
                if (args.length > 3) {
                    this.domain.warning("Too many arguments for tstamp: " + Arrays.toString(args), new Object[0]);
                }
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(now));
    }

    public String _lsr(String[] args) {
        return this.ls(args, true);
    }

    public String _lsa(String[] args) {
        return this.ls(args, false);
    }

    String ls(String[] args, boolean relative) {
        if (args.length < 2) {
            throw new IllegalArgumentException("the ${ls} macro must at least have a directory as parameter");
        }
        File dir = this.domain.getFile(args[1]);
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("the ${ls} macro directory parameter is not absolute: " + dir);
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("the ${ls} macro directory parameter does not exist: " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("the ${ls} macro directory parameter points to a file instead of a directory: " + dir);
        }
        String[] files = dir.list();
        List<String> result = args.length < 3 ? Arrays.asList(files) : new ArrayList<String>();
        int i = 2;
        while (i < args.length) {
            String[] parts;
            String[] stringArray = parts = args[i].split("\\s*,\\s*");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                Instruction instr = Instruction.getPattern(pattern);
                int f = 0;
                while (f < files.length) {
                    if (files[f] != null && instr.matches(files[f])) {
                        if (!instr.isNegated()) {
                            if (relative) {
                                result.add(files[f]);
                            } else {
                                result.add(new File(dir, files[f]).getAbsolutePath());
                            }
                        }
                        files[f] = null;
                    }
                    ++f;
                }
                ++n2;
            }
            ++i;
        }
        return Processor.join(result, ",");
    }

    public String _currenttime(String[] args) {
        return Long.toString(System.currentTimeMillis());
    }

    public String _version(String[] args) {
        Macro.verifyCommand(args, _versionHelp, null, 2, 3);
        String mask = args[1];
        Version version = null;
        if (args.length >= 3) {
            version = new Version(args[2]);
        }
        return this.version(version, mask);
    }

    String version(Version version, String mask) {
        if (version == null) {
            String v = this.domain.getProperty("@");
            if (v == null) {
                this.domain.error("No version specified for ${version} or ${range} and no implicit version ${@} either, mask=%s", mask);
                v = "0";
            }
            version = new Version(v);
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        int i = 0;
        while (i < mask.length()) {
            char c = mask.charAt(i);
            String result = null;
            if (c != '~') {
                if (i == 3) {
                    result = version.getQualifier();
                } else if (Character.isDigit(c)) {
                    result = String.valueOf(c);
                } else {
                    int x = version.get(i);
                    switch (c) {
                        case '+': {
                            ++x;
                            break;
                        }
                        case '-': {
                            --x;
                            break;
                        }
                    }
                    result = Integer.toString(x);
                }
                if (result != null) {
                    sb.append(del);
                    del = ".";
                    sb.append(result);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String _range(String[] args) {
        Macro.verifyCommand(args, _rangeHelp, _rangePattern, 2, 3);
        Version version = null;
        if (args.length >= 3) {
            version = new Version(args[2]);
        }
        String spec = args[1];
        Matcher m = RANGE_MASK.matcher(spec);
        m.matches();
        String floor = m.group(1);
        String floorMask = m.group(2);
        String ceilingMask = m.group(3);
        String ceiling = m.group(4);
        StringBuilder sb = new StringBuilder();
        sb.append(floor);
        sb.append(this.version(version, floorMask));
        sb.append(",");
        sb.append(this.version(version, ceilingMask));
        sb.append(ceiling);
        String s = sb.toString();
        VersionRange vr = new VersionRange(s);
        if (!vr.includes(vr.getHigh()) && !vr.includes(vr.getLow())) {
            this.domain.error("${range} macro created an invalid range %s from %s and mask %s", s, version, spec);
        }
        return sb.toString();
    }

    public String system_internal(boolean allowFail, String[] args) throws Exception {
        Macro.verifyCommand(args, "${" + (allowFail ? "system-allow-fail" : "system") + ";<command>[;<in>]}, execute a system command", null, 2, 3);
        String command = args[1];
        String input = null;
        if (args.length > 2) {
            input = args[2];
        }
        Process process = Runtime.getRuntime().exec(command, null, this.domain.getBase());
        if (input != null) {
            process.getOutputStream().write(input.getBytes("UTF-8"));
        }
        process.getOutputStream().close();
        String s = IO.collect(process.getInputStream(), "UTF-8");
        int exitValue = process.waitFor();
        if (!allowFail && exitValue != 0) {
            this.domain.error("System command " + command + " failed with " + exitValue, new Object[0]);
        }
        return s.trim();
    }

    public String _system(String[] args) throws Exception {
        return this.system_internal(false, args);
    }

    public String _system_allow_fail(String[] args) throws Exception {
        String result = "";
        try {
            result = this.system_internal(true, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public String _env(String[] args) {
        Macro.verifyCommand(args, "${env;<name>}, get the environmet variable", null, 2, 2);
        try {
            return System.getenv(args[1]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String _cat(String[] args) throws IOException {
        Macro.verifyCommand(args, "${cat;<in>}, get the content of a file", null, 2, 2);
        File f = this.domain.getFile(args[1]);
        if (f.isFile()) {
            return IO.collect(f);
        }
        if (f.isDirectory()) {
            return Arrays.toString(f.list());
        }
        try {
            URL url = new URL(args[1]);
            return IO.collect(url, "UTF-8");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void verifyCommand(String[] args, String help, Pattern[] patterns, int low, int high) {
        String message = "";
        if (args.length > high) {
            message = "too many arguments";
        } else if (args.length < low) {
            message = "too few arguments";
        } else {
            int i = 0;
            while (patterns != null && i < patterns.length && i < args.length) {
                Matcher m;
                if (patterns[i] != null && !(m = patterns[i].matcher(args[i])).matches()) {
                    message = String.valueOf(message) + String.format("Argument %s (%s) does not match %s\n", i, args[i], patterns[i].pattern());
                }
                ++i;
            }
        }
        if (message.length() != 0) {
            StringBuilder sb = new StringBuilder();
            String del = "${";
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                sb.append(del);
                sb.append(arg);
                del = ";";
                ++n2;
            }
            sb.append("}, is not understood. ");
            sb.append(message);
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public Properties getFlattenedProperties() {
        this.flattening = true;
        try {
            Properties flattened = new Properties();
            Properties source = this.domain.getProperties();
            Enumeration<?> e = source.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith("_")) continue;
                if (key.startsWith("-")) {
                    flattened.put(key, source.getProperty(key));
                    continue;
                }
                flattened.put(key, this.process(source.getProperty(key)));
            }
            Properties properties = flattened;
            return properties;
        }
        finally {
            this.flattening = false;
        }
    }

    public String _osfile(String[] args) {
        Macro.verifyCommand(args, _fileHelp, null, 3, 3);
        File base = new File(args[1]);
        File f = Processor.getFile(base, args[2]);
        return f.getAbsolutePath();
    }

    public String _path(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while (i < args.length) {
            list.addAll(Processor.split(args[i]));
            ++i;
        }
        return Processor.join(list, File.pathSeparator);
    }

    public static Properties getParent(Properties p) {
        try {
            Field f = Properties.class.getDeclaredField("defaults");
            f.setAccessible(true);
            return (Properties)f.get(p);
        }
        catch (Exception e) {
            Object[] fields = Properties.class.getFields();
            System.out.println(Arrays.toString(fields));
            return null;
        }
    }

    public String process(String line) {
        return this.process(line, this.domain);
    }

    static class Link {
        Link previous;
        String key;
        Processor start;

        public Link(Processor start, Link previous, String key) {
            this.previous = previous;
            this.key = key;
            this.start = start;
        }

        public boolean contains(String key) {
            if (this.key.equals(key)) {
                return true;
            }
            if (this.previous == null) {
                return false;
            }
            return this.previous.contains(key);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String del = "[";
            Link r = this;
            while (r != null) {
                sb.append(del);
                sb.append(r.key);
                del = ",";
                r = r.previous;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

