/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.Workspace;
import aQute.bnd.maven.MavenCommand;
import aQute.bnd.maven.PomFromManifest;
import aQute.bnd.maven.support.MavenRemoteRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.action.Action;
import aQute.bnd.settings.Settings;
import aQute.lib.deployer.FileRepo;
import aQute.lib.io.IO;
import aQute.lib.jardiff.Diff;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.lib.tag.Tag;
import aQute.libg.generics.Create;
import aQute.libg.version.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.prefs.BackingStoreException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bnd
extends Processor {
    Settings settings = new Settings();
    PrintStream out = System.out;
    static boolean exceptions = false;
    static boolean failok = false;
    private Project project;
    static final int BUILD_SOURCES = 1;
    static final int BUILD_POM = 2;
    static final int BUILD_FORCE = 4;
    static final int VERIFY = 1;
    static final int MANIFEST = 2;
    static final int LIST = 4;
    static final int ECLIPSE = 8;
    static final int IMPEXP = 16;
    static final int USES = 32;
    static final int USEDBY = 64;
    static final int COMPONENT = 128;
    static final int METATYPE = 256;
    static final int HEX = 0;

    public static void main(String[] args) {
        block3: {
            bnd main = new bnd();
            try {
                main.run(args);
                if (failok) {
                    return;
                }
                System.exit(main.getErrors().size());
            }
            catch (Exception e) {
                System.err.println("Software error occurred " + e);
                if (!exceptions) break block3;
                e.printStackTrace();
            }
        }
        System.exit(-1);
    }

    void run(String[] args) throws Exception {
        int i = 0;
        try {
            while (i < args.length) {
                if ("-failok".equals(args[i])) {
                    failok = true;
                } else if ("-exceptions".equals(args[i])) {
                    exceptions = true;
                } else if ("-trace".equals(args[i])) {
                    this.setTrace(true);
                } else if ("-pedantic".equals(args[i])) {
                    this.setPedantic(true);
                } else if (args[i].indexOf(61) > 0) {
                    String[] parts = args[i].split("\\s*(?!\\\\)=\\s*");
                    if (parts.length == 2) {
                        this.setProperty(parts[0], parts[1]);
                    } else {
                        this.error("invalid property def: %s", args[i]);
                    }
                } else {
                    if (!"-base".equals(args[i])) break;
                    this.setBase(new File(args[++i]).getAbsoluteFile());
                    if (!this.getBase().isDirectory()) {
                        this.out.println("-base must be a valid directory");
                    } else if (args[i].startsWith("-")) {
                        this.error("Invalid option: ", args[i]);
                    }
                }
                ++i;
            }
            this.project = this.getProject();
            if (this.project != null) {
                this.setParent(this.project);
                this.project.setPedantic(this.isPedantic());
                this.project.setTrace(this.isTrace());
            }
            this.trace("project = %s", this.project);
            if (i >= args.length) {
                if (this.project != null && this.project.isValid()) {
                    this.trace("default build of current project", new Object[0]);
                    this.project.build();
                } else {
                    this.doHelp();
                }
            } else if (!this.doProject(this.project, args, i) && !this.doCommand(args, i)) {
                this.doFiles(args, i);
            }
        }
        catch (Throwable t) {
            if (exceptions) {
                t.printStackTrace();
            }
            this.error("exception %s", t, t);
        }
        int n = 1;
        switch (this.getErrors().size()) {
            case 0: {
                break;
            }
            case 1: {
                System.err.println("One error");
                break;
            }
            default: {
                System.err.println(String.valueOf(this.getErrors().size()) + " errors");
            }
        }
        for (String msg : this.getErrors()) {
            System.err.println(String.valueOf(n++) + " : " + msg);
        }
        n = 1;
        switch (this.getWarnings().size()) {
            case 0: {
                break;
            }
            case 1: {
                System.err.println("One warning");
                break;
            }
            default: {
                System.err.println(String.valueOf(this.getWarnings().size()) + " warnings");
            }
        }
        for (String msg : this.getWarnings()) {
            System.err.println(String.valueOf(n++) + " : " + msg);
        }
        if (this.getErrors().size() != 0) {
            System.err.flush();
            System.out.flush();
            Thread.sleep(1000L);
            System.exit(this.getErrors().size());
        }
    }

    boolean doProject(Project project, String[] args, int i) throws Exception {
        if (project != null) {
            this.trace("project command %s", args[i]);
            Action a = project.getActions().get(args[i]);
            if (a != null) {
                a.execute(project, args[i++]);
                this.getInfo(project);
                return true;
            }
        }
        return false;
    }

    boolean doCommand(String[] args, int i) throws Exception {
        String cmd = args[i];
        this.trace("command %s", cmd);
        if ("wrap".equals(args[i])) {
            this.doWrap(args, ++i);
        } else if ("maven".equals(args[i])) {
            MavenCommand maven = new MavenCommand(this);
            maven.setTrace(this.isTrace());
            maven.setPedantic(this.isPedantic());
            maven.run(args, ++i);
            this.getInfo(maven);
        } else if ("global".equals(args[i])) {
            this.global(args, ++i);
        } else if ("exec".equals(args[i])) {
            this.doRun(args[++i]);
        } else if ("print".equals(args[i])) {
            this.doPrint(args, ++i);
        } else if ("lib".equals(args[i])) {
            this.doLib(args, ++i);
        } else if ("graph".equals(args[i])) {
            this.doDot(args, ++i);
        } else if ("create-repo".equals(args[i])) {
            this.createRepo(args, ++i);
        } else if ("release".equals(args[i])) {
            this.doRelease(args, ++i);
        } else if ("debug".equals(args[i])) {
            this.debug(args, ++i);
        } else if ("bump".equals(args[i])) {
            this.bump(args, ++i);
        } else if ("deliverables".equals(args[i])) {
            this.deliverables(args, ++i);
        } else if ("view".equals(args[i])) {
            this.doView(args, ++i);
        } else if ("buildx".equals(args[i])) {
            this.doBuild(args, ++i);
        } else if ("extract".equals(args[i])) {
            this.doExtract(args, ++i);
        } else if ("patch".equals(args[i])) {
            this.patch(args, ++i);
        } else if ("runtests".equals(args[i])) {
            this.runtests(args, ++i);
        } else if ("xref".equals(args[i])) {
            this.doXref(args, ++i);
        } else if ("eclipse".equals(args[i])) {
            this.doEclipse(args, ++i);
        } else if ("repo".equals(args[i])) {
            this.repo(args, ++i);
        } else if ("diff".equals(args[i])) {
            this.doDiff(args, ++i);
        } else if ("help".equals(args[i])) {
            this.doHelp(args, ++i);
        } else if ("macro".equals(args[i])) {
            this.doMacro(args, ++i);
        } else if ("multibuild".equals(args[i])) {
            this.doMulti(args, ++i);
        } else if ("merge".equals(args[i])) {
            this.doMerge(args, ++i);
        } else {
            this.trace("command %s not found", cmd);
            return false;
        }
        this.trace("command %s executed", cmd);
        return true;
    }

    private void doMulti(String[] args, int i) throws Exception {
    }

    boolean doFiles(String[] args, int i) throws Exception {
        while (i < args.length) {
            String path = args[i];
            if (path.endsWith(".bnd")) {
                this.doBuild(this.getFile(path), new File[0], new File[0], null, "", new File(path).getParentFile(), 0, new HashSet<File>());
            } else if (path.endsWith(".jar") || path.endsWith(".bar")) {
                this.doPrint(path, -1);
            } else if (path.endsWith(".bndrun")) {
                this.doRun(path);
            } else {
                this.error("Unknown file %s", path);
            }
            ++i;
        }
        return true;
    }

    private void doRun(String path) throws Exception {
        Project project;
        File file = this.getFile(path);
        if (!file.isFile()) {
            throw new FileNotFoundException(path);
        }
        File projectDir = file.getParentFile();
        File workspaceDir = projectDir.getParentFile();
        if (workspaceDir == null) {
            workspaceDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".bnd");
        }
        Workspace ws = Workspace.getWorkspace(workspaceDir);
        File bndbnd = new File(projectDir, "bnd.bnd");
        if (bndbnd.isFile()) {
            project = new Project(ws, projectDir, bndbnd);
            project.doIncludeFile(file, true, project.getProperties());
        } else {
            project = new Project(ws, projectDir, file);
        }
        project.setTrace(this.isTrace());
        project.setPedantic(this.isPedantic());
        try {
            project.run();
        }
        catch (Exception e) {
            this.error("Failed to run %s: %s", project, e);
        }
        this.getInfo(project);
    }

    private void bump(String[] args, int i) throws Exception {
        if (this.getProject() == null) {
            this.error("No project found, use -base <dir> bump", new Object[0]);
            return;
        }
        String mask = null;
        if (args.length > i) {
            mask = args[i];
            if (mask.equalsIgnoreCase("major")) {
                mask = "+00";
            } else if (mask.equalsIgnoreCase("minor")) {
                mask = "=+0";
            } else if (mask.equalsIgnoreCase("micro")) {
                mask = "==+";
            } else if (!mask.matches("(+=0){1,3}")) {
                this.error("Invalid mask for version bump %s, is (minor|major|micro|<mask>), see $version for mask", mask);
                return;
            }
        }
        if (mask == null) {
            this.getProject().bump();
        } else {
            this.getProject().bump(mask);
        }
        this.out.println(this.getProject().getProperty("Bundle-Version", "No version found"));
    }

    private void createRepo(String[] args, int i) throws Exception {
        Project project = this.getProject();
        if (project == null) {
            this.error("not in a proper bnd project ... " + this.getBase(), new Object[0]);
            return;
        }
        File out = this.getFile(String.valueOf(project.getName()) + ".repo.jar");
        List<Instruction> skip = Create.list();
        while (i < args.length) {
            if (args[i].equals("-o")) {
                if (++i < args.length) {
                    out = this.getFile(args[i]);
                } else {
                    this.error("No arg for -out", new Object[0]);
                }
            } else if (args[i].equals("-skip")) {
                if (++i < args.length) {
                    Instruction instr = Instruction.getPattern(args[i]);
                    skip.add(instr);
                } else {
                    this.error("No arg for -skip", new Object[0]);
                }
            } else {
                this.error("invalid arg for create-repo %s", args[i]);
            }
            ++i;
        }
        Jar output = new Jar(project.getName());
        output.setDoNotTouchManifest();
        this.addClose(output);
        this.getInfo(project);
        if (this.isOk()) {
            for (Container c : project.getBuildpath()) {
                this.addContainer(skip, output, c);
            }
            for (Container c : project.getRunbundles()) {
                this.addContainer(skip, output, c);
            }
            if (this.isOk()) {
                try {
                    output.write(out);
                }
                catch (Exception e) {
                    this.error("Could not write mini repo %s", e, new Object[0]);
                }
            }
        }
    }

    private void addContainer(Collection<Instruction> skip, Jar output, Container c) throws Exception {
        this.trace("add container " + c, new Object[0]);
        String prefix = "cnf/repo/";
        switch (c.getType()) {
            case ERROR: {
                this.error("Dependencies include %s", c.getError());
                return;
            }
            case REPO: 
            case EXTERNAL: {
                String name = this.getName(skip, prefix, c, ".jar");
                if (name != null) {
                    output.putResource(name, new FileResource(c.getFile()));
                }
                this.trace("storing %s in %s", c, name);
                break;
            }
            case PROJECT: {
                this.trace("not storing project " + c, new Object[0]);
                break;
            }
            case LIBRARY: {
                String name = this.getName(skip, prefix, c, ".lib");
                if (name == null) break;
                output.putResource(name, new FileResource(c.getFile()));
                this.trace("store library %s", name);
                for (Container child : c.getMembers()) {
                    this.trace("store member %s", child);
                    this.addContainer(skip, output, child);
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getName(Collection<Instruction> skip, String prefix, Container c, String extension) throws Exception {
        Manifest m = c.getManifest();
        try {
            String version;
            int n;
            if (m == null) {
                this.error("No manifest found for %s", c);
                return null;
            }
            String bsn = m.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bsn == null) {
                this.error("No bsn in manifest: %s", c);
                return null;
            }
            for (Instruction instr : skip) {
                if (!instr.matches(bsn)) continue;
                if (instr.isNegated()) break;
                return null;
            }
            if ((n = bsn.indexOf(59)) > 0) {
                bsn = bsn.substring(0, n).trim();
            }
            if ((version = m.getMainAttributes().getValue("Bundle-Version")) == null) {
                version = "0";
            }
            Version v = new Version(version);
            version = String.valueOf(v.getMajor()) + "." + v.getMinor() + "." + v.getMicro();
            if (c.getFile() != null && c.getFile().getName().endsWith("-latest.jar")) {
                version = "latest";
            }
            return String.valueOf(prefix) + bsn + "/" + bsn + "-" + version + extension;
        }
        catch (Exception e) {
            this.error("Could not store repo file %s", c);
            return null;
        }
    }

    private void deliverables(String[] args, int i) throws Exception {
        Project project = this.getProject();
        long start = System.currentTimeMillis();
        Collection<Project> projects = project.getWorkspace().getAllProjects();
        ArrayList<Container> containers = new ArrayList<Container>();
        for (Project p : projects) {
            containers.addAll(p.getDeliverables());
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Took " + duration + " ms");
        for (Container c : containers) {
            Version v = new Version(c.getVersion());
            System.out.printf("%-40s %d.%d.%d %s\n", c.getBundleSymbolicName(), v.getMajor(), v.getMinor(), v.getMicro(), c.getFile());
        }
    }

    private int doMacro(String[] args, int i) throws Exception {
        while (i < args.length) {
            String cmd = args[i];
            cmd = cmd.replaceAll("@\\{([^}])\\}", "\\${$1}");
            cmd = cmd.replaceAll(":", ";");
            cmd = cmd.replaceAll("[^$](.*)", "\\${$0}");
            String result = this.getReplacer().process(cmd);
            if (result != null && result.length() != 0) {
                Collection<String> parts = bnd.split(result);
                for (String s : parts) {
                    this.out.println(s);
                }
            } else {
                this.out.println("No result for " + cmd);
            }
            ++i;
        }
        return i;
    }

    private void doRelease(String[] args, int i) throws Exception {
        Project project = this.getProject();
        project.release(false);
        this.getInfo(project);
    }

    private void doXref(String[] args, int i) {
        while (i < args.length) {
            try {
                File file = new File(args[i]);
                Jar jar = new Jar(file.getName(), file);
                try {
                    for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                        String key = entry.getKey();
                        Resource r = entry.getValue();
                        if (!key.endsWith(".class")) continue;
                        InputStream in = r.openInputStream();
                        Clazz clazz = new Clazz(key, r);
                        this.out.print(key);
                        Set<String> xref = clazz.parseClassFile();
                        in.close();
                        for (String element : xref) {
                            this.out.print("\t");
                            this.out.print(element);
                        }
                        this.out.println();
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doEclipse(String[] args, int i) throws Exception {
        block1: {
            dir = new File("").getAbsoluteFile();
            if (args.length != i) ** GOTO lbl7
            this.doEclipse(dir);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.doEclipse(new File(dir, args[i]));
                ++i;
lbl7:
                // 2 sources

                ** while (i < args.length)
            }
        }
    }

    private void doEclipse(File file) throws Exception {
        if (!file.isDirectory()) {
            this.error("Eclipse requires a path to a directory: " + file.getAbsolutePath(), new Object[0]);
        } else {
            File cp = new File(file, ".classpath");
            if (!cp.exists()) {
                this.error("Cannot find .classpath in project directory: " + file.getAbsolutePath(), new Object[0]);
            } else {
                EclipseClasspath eclipse = new EclipseClasspath(this, file.getParentFile(), file);
                this.out.println("Classpath    " + eclipse.getClasspath());
                this.out.println("Dependents   " + eclipse.getDependents());
                this.out.println("Sourcepath   " + eclipse.getSourcepath());
                this.out.println("Output       " + eclipse.getOutput());
                this.out.println();
            }
        }
    }

    private void doBuild(String[] args, int i) throws Exception {
        File[] classpath = new File[]{};
        File workspace = null;
        File[] sourcepath = new File[]{};
        File output = null;
        String eclipse = "";
        int options = 0;
        while (i < args.length) {
            if ("-workspace".startsWith(args[i])) {
                workspace = new File(args[++i]);
            } else if ("-classpath".startsWith(args[i])) {
                classpath = this.getClasspath(args[++i]);
            } else if ("-sourcepath".startsWith(args[i])) {
                String arg = args[++i];
                String[] spaces = arg.split("\\s*,\\s*");
                sourcepath = new File[spaces.length];
                int j = 0;
                while (j < spaces.length) {
                    File f = new File(spaces[j]);
                    if (!f.exists()) {
                        this.error("No such sourcepath entry: " + f.getAbsolutePath(), new Object[0]);
                    }
                    sourcepath[j] = f;
                    ++j;
                }
            } else if ("-eclipse".startsWith(args[i])) {
                eclipse = args[++i];
            } else if ("-noeclipse".startsWith(args[i])) {
                eclipse = null;
            } else if ("-output".startsWith(args[i])) {
                output = new File(args[++i]);
            } else if ("-sources".startsWith(args[i])) {
                options |= 1;
            } else if ("-pom".startsWith(args[i])) {
                options |= 2;
            } else if ("-force".startsWith(args[i])) {
                options |= 4;
            } else if (args[i].startsWith("-")) {
                this.error("Invalid option for bnd: " + args[i], new Object[0]);
            } else {
                File properties = new File(args[i]);
                if (!properties.exists()) {
                    this.error("Cannot find bnd file: " + args[i], new Object[0]);
                } else {
                    if (workspace == null) {
                        workspace = properties.getParentFile();
                    }
                    this.doBuild(properties, classpath, sourcepath, output, eclipse, workspace, options, new HashSet<File>());
                }
                output = null;
            }
            ++i;
        }
    }

    private File[] getClasspath(String string) {
        String[] spaces = string.split("\\s*,\\s*");
        File[] classpath = new File[spaces.length];
        int j = 0;
        while (j < spaces.length) {
            File f = new File(spaces[j]);
            if (!f.exists()) {
                this.error("No such classpath entry: " + f.getAbsolutePath(), new Object[0]);
            }
            classpath[j] = f;
            ++j;
        }
        return classpath;
    }

    private void doBuild(File properties, File[] classpath, File[] sourcepath, File output, String eclipse, File workspace, int options, Set<File> building) throws Exception {
        if (building.contains(properties = properties.getAbsoluteFile())) {
            this.error("Circular dependency in pre build " + properties, new Object[0]);
            return;
        }
        building.add(properties);
        Builder builder = new Builder();
        try {
            String prebuild;
            builder.setPedantic(this.isPedantic());
            builder.setProperties(properties);
            if (output == null) {
                String out = builder.getProperty("-output");
                if (out != null) {
                    output = bnd.getFile(properties.getParentFile(), out);
                    if (!output.getName().endsWith(".jar")) {
                        output.mkdirs();
                    }
                } else {
                    output = properties.getAbsoluteFile().getParentFile();
                }
            }
            if ((prebuild = builder.getProperty("-prebuild")) != null) {
                this.prebuild(prebuild, properties.getParentFile(), classpath, sourcepath, output, eclipse, workspace, options, building);
            }
            this.doEclipse(builder, properties, classpath, sourcepath, eclipse, workspace);
            if ((options & 1) != 0) {
                builder.getProperties().setProperty("-sources", "true");
            }
            if (failok) {
                builder.setProperty("-failok", "true");
            }
            Jar jar = builder.build();
            this.getInfo(builder);
            if (this.getErrors().size() > 0 && !failok) {
                return;
            }
            String name = String.valueOf(builder.getBsn()) + ".jar";
            if (output.isDirectory()) {
                output = new File(output, name);
            }
            output.getParentFile().mkdirs();
            if ((options & 2) != 0) {
                PomFromManifest r = new PomFromManifest(jar.getManifest());
                jar.putResource("pom.xml", r);
                String path = output.getName().replaceAll("\\.jar$", ".pom");
                if (path.equals(output.getName())) {
                    path = String.valueOf(output.getName()) + ".pom";
                }
                File pom = new File(output.getParentFile(), path);
                FileOutputStream out = new FileOutputStream(pom);
                try {
                    r.write(out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            jar.setName(output.getName());
            String msg = "";
            if (!output.exists() || output.lastModified() <= jar.lastModified() || (options & 4) != 0) {
                jar.write(output);
            } else {
                msg = "(not modified)";
            }
            this.statistics(jar, output, msg);
        }
        finally {
            builder.close();
        }
    }

    private void prebuild(String prebuild, File base, File[] classpath, File[] sourcepath, File output, String eclipse2, File workspace, int options, Set<File> building) throws Exception {
        if (output.isFile()) {
            output = output.getParentFile();
        }
        Collection<String> parts = Processor.split(prebuild);
        for (String part : parts) {
            File f = new File(part);
            if (!f.exists()) {
                f = new File(base, part);
            }
            if (!f.exists()) {
                this.error("Trying to build a non-existent file: " + parts, new Object[0]);
                continue;
            }
            try {
                this.doBuild(f, classpath, sourcepath, output, eclipse2, workspace, options, building);
            }
            catch (Exception e) {
                this.error("Trying to build: " + part + " " + e, new Object[0]);
            }
        }
    }

    private void statistics(Jar jar, File output, String msg) {
        this.out.println(String.valueOf(jar.getName()) + " " + jar.getResources().size() + " " + output.length() + msg);
    }

    void doEclipse(Builder builder, File properties, File[] classpath, File[] sourcepath, String eclipse, File workspace) throws IOException {
        if (eclipse != null) {
            File project = new File(workspace, eclipse).getAbsoluteFile();
            if (project.exists() && project.isDirectory()) {
                try {
                    EclipseClasspath path = new EclipseClasspath(this, project.getParentFile(), project);
                    List<File> newClasspath = Create.copy(Arrays.asList(classpath));
                    newClasspath.addAll(path.getClasspath());
                    classpath = newClasspath.toArray(classpath);
                    List<File> newSourcepath = Create.copy(Arrays.asList(sourcepath));
                    newSourcepath.addAll(path.getSourcepath());
                    sourcepath = newSourcepath.toArray(sourcepath);
                }
                catch (Exception e) {
                    if (eclipse.length() > 0) {
                        this.error("Eclipse specified (" + eclipse + ") but getting error processing: " + e, new Object[0]);
                    }
                }
            } else if (eclipse.length() > 0) {
                this.error("Eclipse specified (" + eclipse + ") but no project directory found", new Object[0]);
            }
        }
        builder.setClasspath(classpath);
        builder.setSourcepath(sourcepath);
    }

    private void doHelp() {
        this.doHelp(new String[0], 0);
    }

    /*
     * Unable to fully structure code
     */
    private void doHelp(String[] args, int i) {
        block10: {
            if (args.length > i) ** GOTO lbl21
            this.out.println("bnd -failok? -exceptions? ( wrap | print | build | eclipse | xref | view )?");
            this.out.println("See http://www.aQute.biz/Code/Bnd");
            break block10;
lbl-1000:
            // 1 sources

            {
                if ("wrap".equals(args[i])) {
                    this.out.println("bnd wrap (-output <file|dir>)? (-properties <file>)? <jar-file>");
                } else if ("print".equals(args[i])) {
                    this.out.println("bnd wrap -verify? -manifest? -list? -eclipse <jar-file>");
                } else if ("build".equals(args[i])) {
                    this.out.println("bnd build (-output <file|dir>)? (-classpath <list>)? (-sourcepath <list>)? ");
                    this.out.println("    -eclipse? -noeclipse? -sources? <bnd-file>");
                } else if ("eclipse".equals(args[i])) {
                    this.out.println("bnd eclipse");
                } else if ("view".equals(args[i])) {
                    this.out.println("bnd view <file> <resource-names>+");
                }
                ++i;
lbl21:
                // 2 sources

                ** while (args.length > i)
            }
        }
    }

    private void doPrint(String[] args, int i) throws Exception {
        int options = 0;
        while (i < args.length) {
            if ("-verify".startsWith(args[i])) {
                options |= 1;
            } else if ("-manifest".startsWith(args[i])) {
                options |= 2;
            } else if ("-list".startsWith(args[i])) {
                options |= 4;
            } else if ("-eclipse".startsWith(args[i])) {
                options |= 8;
            } else if ("-impexp".startsWith(args[i])) {
                options |= 0x10;
            } else if ("-uses".startsWith(args[i])) {
                options |= 0x20;
            } else if ("-usedby".startsWith(args[i])) {
                options |= 0x40;
            } else if ("-component".startsWith(args[i])) {
                options |= 0x80;
            } else if ("-metatype".startsWith(args[i])) {
                options |= 0x100;
            } else if ("-all".startsWith(args[i])) {
                options = -1;
            } else if (args[i].startsWith("-")) {
                this.error("Invalid option for print: " + args[i], new Object[0]);
            } else {
                this.doPrint(args[i], options);
            }
            ++i;
        }
    }

    public void doPrint(String string, int options) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            this.error("File to print not found: " + string, new Object[0]);
        } else {
            if (options == 0) {
                options = 51;
            }
            this.doPrint(file, options);
        }
    }

    private void doPrint(File file, int options) throws ZipException, IOException, Exception {
        block24: {
            Jar jar = new Jar(file.getName(), file);
            try {
                if ((options & 1) != 0) {
                    Verifier verifier = new Verifier(jar);
                    verifier.setPedantic(this.isPedantic());
                    verifier.verify();
                    this.getInfo(verifier);
                }
                if ((options & 2) != 0) {
                    Manifest manifest = jar.getManifest();
                    if (manifest == null) {
                        this.warning("JAR has no manifest " + file, new Object[0]);
                    } else {
                        this.out.println("[MANIFEST " + jar.getName() + "]");
                        TreeSet<String> sorted = new TreeSet<String>();
                        for (Object element : manifest.getMainAttributes().keySet()) {
                            sorted.add(element.toString());
                        }
                        for (String key : sorted) {
                            String value = manifest.getMainAttributes().getValue(key);
                            this.format("%-40s %-40s\r\n", key, value);
                        }
                    }
                    this.out.println();
                }
                if ((options & 0x10) != 0) {
                    this.out.println("[IMPEXP]");
                    Manifest m = jar.getManifest();
                    if (m != null) {
                        Map<String, Map<String, String>> imports = this.parseHeader(m.getMainAttributes().getValue("Import-Package"));
                        Map<String, Map<String, String>> exports = this.parseHeader(m.getMainAttributes().getValue("Export-Package"));
                        for (String p : exports.keySet()) {
                            Map<String, String> attrs;
                            if (!imports.containsKey(p) || !(attrs = imports.get(p)).containsKey("version")) continue;
                            exports.get(p).put("imported-as", attrs.get("version"));
                        }
                        this.print("Import-Package", new TreeMap<String, Map<String, String>>(imports));
                        this.print("Export-Package", new TreeMap<String, Map<String, String>>(exports));
                    } else {
                        this.warning("File has no manifest", new Object[0]);
                    }
                }
                if ((options & 0x60) != 0) {
                    this.out.println();
                    Analyzer analyzer = new Analyzer();
                    analyzer.setPedantic(this.isPedantic());
                    analyzer.setJar(jar);
                    analyzer.analyze();
                    if ((options & 0x20) != 0) {
                        this.out.println("[USES]");
                        this.printMapOfSets(new TreeMap<String, Set<String>>(analyzer.getUses()));
                        this.out.println();
                    }
                    if ((options & 0x40) != 0) {
                        this.out.println("[USEDBY]");
                        this.printMapOfSets(this.invertMapOfCollection(analyzer.getUses()));
                    }
                }
                if ((options & 0x80) != 0) {
                    this.printComponents(this.out, jar);
                }
                if ((options & 0x100) != 0) {
                    this.printMetatype(this.out, jar);
                }
                if ((options & 4) == 0) break block24;
                this.out.println("[LIST]");
                for (Map.Entry<String, Map<String, Resource>> entry : jar.getDirectories().entrySet()) {
                    String name = entry.getKey();
                    Map<String, Resource> contents = entry.getValue();
                    this.out.println(name);
                    if (contents != null) {
                        for (String element : contents.keySet()) {
                            String extra;
                            Resource r;
                            int n = element.lastIndexOf(47);
                            if (n > 0) {
                                element = element.substring(n + 1);
                            }
                            this.out.print("  ");
                            this.out.print(element);
                            String path = element;
                            if (name.length() != 0) {
                                path = String.valueOf(name) + "/" + element;
                            }
                            if ((r = contents.get(path)) != null && (extra = r.getExtra()) != null) {
                                this.out.print(" extra='" + this.escapeUnicode(extra) + "'");
                            }
                            this.out.println();
                        }
                        continue;
                    }
                    this.out.println(String.valueOf(name) + " <no contents>");
                }
                this.out.println();
            }
            finally {
                jar.close();
            }
        }
    }

    private final char nibble(int i) {
        return "0123456789ABCDEF".charAt(i & 0xF);
    }

    private final String escapeUnicode(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~' && c != '\\') {
                sb.append(c);
            } else {
                sb.append("\\u");
                sb.append(this.nibble(c >> 12));
                sb.append(this.nibble(c >> 8));
                sb.append(this.nibble(c >> 4));
                sb.append(this.nibble(c));
            }
            ++i;
        }
        return sb.toString();
    }

    private void printComponents(PrintStream out, Jar jar) throws Exception {
        out.println("[COMPONENTS]");
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            out.println("No manifest");
            return;
        }
        String componentHeader = manifest.getMainAttributes().getValue("Service-Component");
        Map<String, Map<String, String>> clauses = this.parseHeader(componentHeader);
        for (String path : clauses.keySet()) {
            out.println(path);
            Resource r = jar.getResource(path);
            if (r != null) {
                InputStreamReader ir = new InputStreamReader(r.openInputStream(), Constants.DEFAULT_CHARSET);
                OutputStreamWriter or = new OutputStreamWriter((OutputStream)out, Constants.DEFAULT_CHARSET);
                try {
                    this.copy(ir, or);
                    continue;
                }
                finally {
                    or.flush();
                    ir.close();
                }
            }
            out.println("  - no resource");
            this.warning("No Resource found for service component: " + path, new Object[0]);
        }
        out.println();
    }

    private void printMetatype(PrintStream out, Jar jar) throws Exception {
        out.println("[METATYPE]");
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            out.println("No manifest");
            return;
        }
        Map<String, Resource> map = jar.getDirectories().get("OSGI-INF/metatype");
        if (map != null) {
            for (Map.Entry<String, Resource> entry : map.entrySet()) {
                out.println(entry.getKey());
                IO.copy(entry.getValue().openInputStream(), (OutputStream)out);
                out.println();
            }
            out.println();
        }
    }

    Map<String, Set<String>> invertMapOfCollection(Map<String, Set<String>> map) {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            if (name.startsWith("java.") && !name.equals("java.sql")) continue;
            Collection used = entry.getValue();
            for (String n : used) {
                if (n.startsWith("java.") && !n.equals("java.sql")) continue;
                TreeSet<String> set = (TreeSet<String>)result.get(n);
                if (set == null) {
                    set = new TreeSet<String>();
                    result.put(n, set);
                }
                set.add(name);
            }
        }
        return result;
    }

    void printMapOfSets(Map<String, Set<String>> map) {
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            TreeSet<String> used = new TreeSet<String>((Collection)entry.getValue());
            Iterator k = used.iterator();
            while (k.hasNext()) {
                String n = (String)k.next();
                if (!n.startsWith("java.") || n.equals("java.sql")) continue;
                k.remove();
            }
            String list = this.vertical(40, used);
            this.format("%-40s %s", name, list);
        }
    }

    String vertical(int padding, Set<String> used) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (String name : used) {
            sb.append(del);
            sb.append(name);
            sb.append("\r\n");
            del = this.pad(padding);
        }
        if (sb.length() == 0) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    String pad(int i) {
        StringBuffer sb = new StringBuffer();
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private void doView(String[] args, int i) throws Exception {
        int options = 0;
        String charset = "UTF-8";
        File output = null;
        while (i < args.length) {
            if ("-charset".startsWith(args[i])) {
                charset = args[++i];
            } else {
                if (!"-output".startsWith(args[i])) break;
                output = new File(args[++i]);
            }
            ++i;
        }
        if (i >= args.length) {
            this.error("Insufficient arguments for view, no JAR", new Object[0]);
            return;
        }
        String jar = args[i++];
        if (i >= args.length) {
            this.error("No Files to view", new Object[0]);
            return;
        }
        this.doView(jar, args, i, charset, options, output);
    }

    private void doView(String jar, String[] args, int i, String charset, int options, File output) {
        File path = new File(jar).getAbsoluteFile();
        File dir = path.getParentFile();
        if (dir == null) {
            dir = new File("");
        }
        if (!dir.exists()) {
            this.error("No such file: " + dir.getAbsolutePath(), new Object[0]);
            return;
        }
        String name = path.getName();
        if (name == null) {
            name = "META-INF/MANIFEST.MF";
        }
        Instruction instruction = Instruction.getPattern(path.getName());
        File[] children = dir.listFiles();
        int j = 0;
        while (j < children.length) {
            String base = children[j].getName();
            if (instruction.matches(base) ^ instruction.isNegated()) {
                while (i < args.length) {
                    this.doView(children[j], args[i], charset, options, output);
                    ++i;
                }
            }
            ++j;
        }
    }

    private void doView(File file, String resource, String charset, int options, File output) {
        try {
            Instruction instruction = Instruction.getPattern(resource);
            FileInputStream fin = new FileInputStream(file);
            ZipInputStream in = new ZipInputStream(fin);
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (instruction.matches(entry.getName()) ^ instruction.isNegated()) {
                    this.doView(entry.getName(), in, charset, options, output);
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
            in.close();
            fin.close();
        }
        catch (Exception e) {
            this.out.println("Can not process: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void doView(String name, ZipInputStream in, String charset, int options, File output) throws Exception {
        int n = name.lastIndexOf(47);
        name = name.substring(n + 1);
        InputStreamReader rds = new InputStreamReader((InputStream)in, charset);
        OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)this.out, Constants.DEFAULT_CHARSET);
        if (output != null) {
            wrt = output.isDirectory() ? new FileWriter(new File(output, name)) : new FileWriter(output);
        }
        this.copy(rds, wrt);
        if (output != null) {
            wrt.close();
        } else {
            wrt.flush();
        }
    }

    private void copy(Reader rds, Writer wrt) throws IOException {
        char[] buffer = new char[1024];
        int size = rds.read(buffer);
        while (size > 0) {
            wrt.write(buffer, 0, size);
            size = rds.read(buffer);
        }
    }

    private void print(String msg, Map<String, Map<String, String>> ports) {
        if (ports.isEmpty()) {
            return;
        }
        this.out.println(msg);
        for (Map.Entry<String, Map<String, String>> entry : ports.entrySet()) {
            String key = entry.getKey();
            Map<String, String> clause = Create.copy(entry.getValue());
            clause.remove("uses:");
            this.format("  %-38s %s\r\n", key.trim(), clause.isEmpty() ? "" : clause.toString());
        }
    }

    private void format(String string, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            block0 : switch (c) {
                case '%': {
                    String s = "" + objects[index++];
                    int width = 0;
                    int justify = -1;
                    int n = ++i;
                    ++i;
                    c = string.charAt(n);
                    switch (c) {
                        case '-': {
                            justify = -1;
                            break;
                        }
                        case '+': {
                            justify = 1;
                            break;
                        }
                        case '|': {
                            justify = 0;
                            break;
                        }
                    }
                    int n2 = --i;
                    ++i;
                    c = string.charAt(n2);
                    while (c >= '0' && c <= '9') {
                        width *= 10;
                        width += c - 48;
                        c = string.charAt(i++);
                    }
                    if (c != 's') {
                        throw new IllegalArgumentException("Invalid sprintf format:  " + string);
                    }
                    if (s.length() > width) {
                        sb.append(s);
                        break;
                    }
                    switch (justify) {
                        case -1: {
                            sb.append(s);
                            int j = 0;
                            while (j < width - s.length()) {
                                sb.append(" ");
                                ++j;
                            }
                            break block0;
                        }
                        case 1: {
                            int j = 0;
                            while (j < width - s.length()) {
                                sb.append(" ");
                                ++j;
                            }
                            sb.append(s);
                            break;
                        }
                        case 0: {
                            int spaces = (width - s.length()) / 2;
                            int j = 0;
                            while (j < spaces) {
                                sb.append(" ");
                                ++j;
                            }
                            sb.append(s);
                            j = 0;
                            while (j < width - s.length() - spaces) {
                                sb.append(" ");
                                ++j;
                            }
                            break block8;
                        }
                    }
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        this.out.print(sb);
    }

    private void doWrap(String[] args, int i) throws Exception {
        int options = 0;
        File properties = null;
        File output = null;
        File[] classpath = null;
        while (i < args.length) {
            if ("-output".startsWith(args[i])) {
                output = new File(args[++i]);
            } else if ("-properties".startsWith(args[i])) {
                properties = new File(args[++i]);
            } else if ("-classpath".startsWith(args[i])) {
                classpath = this.getClasspath(args[++i]);
            } else {
                File bundle = new File(args[i]);
                this.doWrap(properties, bundle, output, classpath, options, null);
            }
            ++i;
        }
    }

    public boolean doWrap(File properties, File bundle, File output, File[] classpath, int options, Map<String, String> additional) throws Exception {
        if (!bundle.exists()) {
            this.error("No such file: " + bundle.getAbsolutePath(), new Object[0]);
            return false;
        }
        Analyzer analyzer = new Analyzer();
        try {
            String path;
            analyzer.setPedantic(this.isPedantic());
            analyzer.setJar(bundle);
            Jar dot = analyzer.getJar();
            if (properties != null) {
                analyzer.setProperties(properties);
            }
            if (additional != null) {
                analyzer.putAll(additional, false);
            }
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                String base = bundle.getName();
                Matcher m = p.matcher(base);
                base = "Untitled";
                if (m.matches()) {
                    base = m.group(1);
                } else {
                    this.error("Can not calculate name of output bundle, rename jar or use -properties", new Object[0]);
                }
                analyzer.setProperty("Bundle-SymbolicName", base);
            }
            if (analyzer.getProperty("Export-Package") == null) {
                String export = analyzer.calculateExportsFromContents(dot);
                analyzer.setProperty("Export-Package", export);
            }
            if (classpath != null) {
                analyzer.setClasspath(classpath);
            }
            analyzer.mergeManifest(dot.getManifest());
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Builder.cleanupVersion(version);
                analyzer.setProperty("Bundle-Version", version);
            }
            if (output == null) {
                output = properties != null ? properties.getAbsoluteFile().getParentFile() : bundle.getAbsoluteFile().getParentFile();
            }
            path = (path = bundle.getName()).endsWith(".jar") ? String.valueOf(path.substring(0, path.length() - ".jar".length())) + ".bar" : String.valueOf(bundle.getName()) + ".bar";
            if (output.isDirectory()) {
                output = new File(output, path);
            }
            analyzer.calcManifest();
            Jar jar = analyzer.getJar();
            this.getInfo(analyzer);
            this.statistics(jar, output, "");
            File f = File.createTempFile("tmpbnd", ".jar");
            f.deleteOnExit();
            try {
                jar.write(f);
                jar.close();
                if (!f.renameTo(output)) {
                    IO.copy(f, output);
                }
            }
            finally {
                f.delete();
            }
            boolean bl = this.getErrors().size() == 0;
            return bl;
        }
        finally {
            analyzer.close();
        }
    }

    void doDiff(String[] args, int first) throws Exception {
        Jar jar;
        File base = new File("");
        boolean strict = false;
        Jar[] targets = new Jar[2];
        int n = 0;
        int i = first;
        while (i < args.length) {
            if ("-d".equals(args[i])) {
                base = bnd.getFile(base, args[++i]);
            } else if ("-strict".equals(args[i])) {
                strict = "true".equalsIgnoreCase(args[++i]);
            } else if (args[i].startsWith("-")) {
                this.error("Unknown option for diff: " + args[i], new Object[0]);
            } else if (n >= 2) {
                System.err.println("Must have 2 files ... not more");
            } else {
                File f = bnd.getFile(base, args[i]);
                if (!f.isFile()) {
                    System.err.println("Not a file: " + f);
                } else {
                    try {
                        jar = new Jar(f);
                        targets[n++] = jar;
                    }
                    catch (Exception e) {
                        System.err.println("Not a JAR: " + f);
                    }
                }
            }
            ++i;
        }
        if (n != 2) {
            System.err.println("Must have 2 files ...");
            return;
        }
        Diff diff = new Diff();
        Map<String, Object> map = diff.diff(targets[0], targets[1], strict);
        diff.print(System.out, map, 0);
        Jar[] jarArray = targets;
        int n2 = targets.length;
        int n3 = 0;
        while (n3 < n2) {
            jar = jarArray[n3];
            jar.close();
            ++n3;
        }
        diff.close();
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public Project getProject() throws Exception {
        block6: {
            block5: {
                if (this.project != null) {
                    return this.project;
                }
                try {
                    this.project = Workspace.getProject(this.getBase());
                    if (this.project != null) break block5;
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (this.project.isValid()) break block6;
            return null;
        }
        return this.project;
    }

    public void debug(String[] args, int i) throws Exception {
        Project project = this.getProject();
        System.out.println("Project: " + project);
        Properties p = project.getFlattenedProperties();
        for (Object k : p.keySet()) {
            String key = (String)k;
            String s = p.getProperty(key);
            Collection<String> l = null;
            if (s.indexOf(44) > 0) {
                l = bnd.split(s);
            } else if (s.indexOf(58) > 0) {
                l = bnd.split(s, "\\s*:\\s*");
            }
            if (l != null) {
                String del = key;
                for (String ss : l) {
                    System.out.printf("%-40s %s\n", del, ss);
                    del = "";
                }
                continue;
            }
            System.out.printf("%-40s %s\n", key, s);
        }
    }

    public void repo(String[] args, int i) throws Exception {
        String bsn = null;
        String version = null;
        List<RepositoryPlugin> repos = new ArrayList<RepositoryPlugin>();
        RepositoryPlugin writable = null;
        Project p = Workspace.getProject(this.getBase());
        if (p != null) {
            repos.addAll(p.getWorkspace().getRepositories());
            for (RepositoryPlugin rpp : repos) {
                if (!rpp.canWrite()) continue;
                writable = rpp;
                break;
            }
        }
        while (i < args.length) {
            if ("repos".equals(args[i])) {
                int n = 0;
                for (RepositoryPlugin repo : repos) {
                    this.out.printf("%3d. %s\n", n++, repo);
                }
                return;
            }
            if ("list".equals(args[i])) {
                String mask = null;
                if (i < args.length - 1) {
                    mask = args[++i];
                }
                this.repoList(repos, mask);
                return;
            }
            if ("--repo".equals(args[i]) || "-r".equals(args[i])) {
                String location;
                if ((location = args[++i]).equals("maven")) {
                    System.out.println("Maven");
                    MavenRemoteRepository maven = new MavenRemoteRepository();
                    maven.setProperties(new HashMap<String, String>());
                    maven.setReporter(this);
                    repos = Arrays.asList(maven);
                } else {
                    RepositoryPlugin repo;
                    repo = new FileRepo();
                    ((FileRepo)repo).setReporter(this);
                    ((FileRepo)repo).setLocation(location);
                    repos = Arrays.asList(repo);
                    writable = repo;
                }
            } else {
                if ("spring".equals(args[i])) {
                    this.error("not supported anymore", new Object[0]);
                    return;
                }
                if ("put".equals(args[i])) {
                    while (i < args.length - 1) {
                        String source = args[++i];
                        try {
                            URL url = IO.toURL(source, this.getBase());
                            this.trace("put from %s", url);
                            InputStream in = url.openStream();
                            try {
                                Jar jar = new Jar(url.toString(), in);
                                Verifier verifier = new Verifier(jar);
                                verifier.verify();
                                this.getInfo(verifier);
                                if (!this.isOk()) continue;
                                File put = writable.put(jar);
                                this.trace("stored in %s", put);
                            }
                            finally {
                                in.close();
                            }
                        }
                        catch (Exception e) {
                            this.error("putting %s into %s, exception: %s", source, writable, e);
                        }
                    }
                    return;
                }
                if ("get".equals(args[i])) {
                    if (i < args.length) {
                        this.error("repo get requires a bsn, see repo help", new Object[0]);
                        return;
                    }
                    bsn = args[i++];
                    if (i < args.length) {
                        this.error("repo get requires a version, see repo help", new Object[0]);
                        return;
                    }
                    version = args[i++];
                    for (RepositoryPlugin repo : repos) {
                        File f = repo.get(bsn, version, RepositoryPlugin.Strategy.LOWEST, null);
                        if (f == null) continue;
                        if (i < args.length) {
                            File out = this.getFile(args[i++]);
                            IO.copy(f, out);
                        } else {
                            this.out.println(f);
                        }
                        return;
                    }
                    this.error("cannot find %s-%s in %s", bsn, version, repos);
                    return;
                }
            }
            ++i;
        }
        if (i < args.length && !"help".equals(args[i])) {
            this.out.println("Unknown repo command: " + args[i]);
        }
        this.out.println(" bnd repo [--repo|-r ('maven'| <dir>)]*");
        this.out.println("        repos                          # list the repositories");
        this.out.println("        list                           # list all content (not always possible)");
        this.out.println("        get <bsn> <version> <file>?    # get an artifact");
        this.out.println("        put <file>+                    # put in artifacts");
        this.out.println("        help");
    }

    private void repoPut(RepositoryPlugin writable, Project project, String file, String bsn, String version) throws Exception {
        Jar jar = null;
        int n = file.indexOf(58);
        if (n > 1 && n < 10) {
            jar = project.getValidJar(new URL(file));
        } else {
            File f = this.getFile(file);
            if (f.isFile()) {
                jar = project.getValidJar(f);
            }
        }
        if (jar != null) {
            Manifest manifest = jar.getManifest();
            if (bsn != null) {
                manifest.getMainAttributes().putValue("Bundle-SymbolicName", bsn);
            }
            if (version != null) {
                manifest.getMainAttributes().putValue("Bundle-Version", version);
            }
            writable.put(jar);
        } else {
            this.error("There is no such file or url: " + file, new Object[0]);
        }
    }

    void repoList(List<RepositoryPlugin> repos, String mask) throws Exception {
        this.trace("list repo " + repos + " " + mask, new Object[0]);
        TreeSet<String> bsns = new TreeSet<String>();
        for (RepositoryPlugin repo : repos) {
            bsns.addAll(repo.list(mask));
        }
        for (String bsn : bsns) {
            TreeSet<Version> versions = new TreeSet<Version>();
            for (RepositoryPlugin repo : repos) {
                List<Version> result = repo.versions(bsn);
                if (result == null) continue;
                versions.addAll(result);
            }
            this.out.printf("%-40s %s\n", bsn, versions);
        }
    }

    void patch(String[] args, int i) throws Exception {
        while (i < args.length) {
            if ("create".equals(args[i]) && i + 3 < args.length) {
                this.createPatch(args[++i], args[++i], args[++i]);
            } else if ("apply".equals(args[i]) && i + 3 < args.length) {
                this.applyPatch(args[++i], args[++i], args[++i]);
            } else if ("help".equals(args[i])) {
                this.out.println("patch (create <old> <new> <patch> | patch <old> <patch> <new>)");
            } else {
                this.out.println("Patch does not recognize command? " + Arrays.toString(args));
            }
            ++i;
        }
    }

    void createPatch(String old, String newer, String patch) throws Exception {
        Jar a = new Jar(new File(old));
        Manifest am = a.getManifest();
        Jar b = new Jar(new File(newer));
        Manifest bm = b.getManifest();
        Set delete = this.newSet();
        for (String path : a.getResources().keySet()) {
            Resource br = b.getResource(path);
            if (br == null) {
                this.trace("DELETE    %s", path);
                delete.add(path);
                continue;
            }
            Resource ar = a.getResource(path);
            if (this.isEqual(ar, br)) {
                this.trace("UNCHANGED %s", path);
                b.remove(path);
                continue;
            }
            this.trace("UPDATE    %s", path);
        }
        bm.getMainAttributes().putValue("Patch-Delete", bnd.join(delete, ", "));
        bm.getMainAttributes().putValue("Patch-Version", am.getMainAttributes().getValue("Bundle-Version"));
        b.write(new File(patch));
        a.close();
        a.close();
    }

    private boolean isEqual(Resource ar, Resource br) throws Exception {
        InputStream ain = ar.openInputStream();
        try {
            InputStream bin = br.openInputStream();
            try {
                int bn;
                int an;
                while ((an = ain.read()) == (bn = bin.read())) {
                    if (an != -1) continue;
                }
            }
            catch (Throwable throwable) {
                bin.close();
                throw throwable;
            }
            {
                bin.close();
                return true;
            }
            bin.close();
            return false;
        }
        finally {
            ain.close();
        }
    }

    void applyPatch(String old, String patch, String newer) throws Exception {
        Jar a = new Jar(new File(old));
        Jar b = new Jar(new File(patch));
        Manifest bm = b.getManifest();
        String patchDelete = bm.getMainAttributes().getValue("Patch-Delete");
        String patchVersion = bm.getMainAttributes().getValue("Patch-Version");
        if (patchVersion == null) {
            this.error("To patch, you must provide a patch bundle.\nThe given " + patch + " bundle does not contain the Patch-Version header", new Object[0]);
            return;
        }
        Collection<String> delete = bnd.split(patchDelete);
        HashSet<String> paths = new HashSet<String>(a.getResources().keySet());
        paths.removeAll(delete);
        for (String path : paths) {
            Resource br = b.getResource(path);
            if (br != null) continue;
            b.putResource(path, a.getResource(path));
        }
        bm.getMainAttributes().putValue("Bundle-Version", patchVersion);
        b.write(new File(newer));
        a.close();
        b.close();
    }

    public void runtests(String[] args, int i) throws Exception {
        Tag e;
        int errors = 0;
        File cwd = new File("").getAbsoluteFile();
        Workspace ws = new Workspace(cwd);
        File reportDir = this.getFile("reports");
        IO.delete(reportDir);
        reportDir.mkdirs();
        Tag summary = new Tag("summary", new Object[0]);
        summary.addAttribute("date", new Date());
        summary.addAttribute("ws", ws.getBase());
        try {
            boolean hadOne = false;
            while (i < args.length) {
                if (args[i].startsWith("-reportdir")) {
                    if (!(reportDir = this.getFile(args[++i]).getAbsoluteFile()).isDirectory()) {
                        this.error("reportdir must be a directory " + reportDir, new Object[0]);
                    }
                } else if (args[i].startsWith("-title")) {
                    summary.addAttribute("title", args[++i]);
                } else if (args[i].startsWith("-dir")) {
                    cwd = this.getFile(args[++i]).getAbsoluteFile();
                } else if (args[i].startsWith("-workspace")) {
                    File tmp = this.getFile(args[++i]).getAbsoluteFile();
                    ws = Workspace.getWorkspace(tmp);
                } else {
                    File f = this.getFile(args[i]);
                    errors += this.runtTest(f, ws, reportDir, summary);
                    hadOne = true;
                }
                ++i;
            }
            if (!hadOne) {
                File[] files = cwd.listFiles();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".bnd")) {
                        errors += this.runtTest(f, ws, reportDir, summary);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.error("FAILURE IN RUNTESTS", e2, new Object[0]);
            ++errors;
        }
        if (errors > 0) {
            summary.addAttribute("errors", errors);
        }
        for (String error : this.getErrors()) {
            e = new Tag("error", new Object[0]);
            e.addContent(error);
        }
        for (String warning : this.getWarnings()) {
            e = new Tag("warning", new Object[0]);
            e.addContent(warning);
        }
        File r = this.getFile(reportDir + "/summary.xml");
        FileOutputStream out = new FileOutputStream(r);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, Constants.DEFAULT_CHARSET));
        try {
            summary.print(0, pw);
        }
        finally {
            pw.close();
            out.close();
        }
        if (errors != 0) {
            this.error("Errors found %s", errors);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int runtTest(File testFile, Workspace ws, File reportDir, Tag summary) throws Exception {
        File tmpDir = new File(reportDir, "tmp");
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        Tag test = new Tag(summary, "test", new Object[0]);
        test.addAttribute("path", testFile.getAbsolutePath());
        if (!testFile.isFile()) {
            this.error("No bnd file: %s", testFile);
            test.addAttribute("exception", "No bnd file found");
            throw new FileNotFoundException("No bnd file found for " + testFile.getAbsolutePath());
        }
        Project project = new Project(ws, testFile.getAbsoluteFile().getParentFile(), testFile.getAbsoluteFile());
        project.setTrace(this.isTrace());
        project.setProperty("-nobundles", "true");
        ProjectTester tester = project.getProjectTester();
        this.getInfo(project, String.valueOf(project.toString()) + ": ");
        if (!this.isOk()) {
            throw new IllegalStateException("Errors found while creating the bnd test project " + testFile.getAbsolutePath());
        }
        tester.setContinuous(false);
        tester.setReportDir(tmpDir);
        test.addAttribute("title", project.toString());
        long start = System.currentTimeMillis();
        try {
            int errors = tester.test();
            Collection<File> reports = tester.getReports();
            for (File report : reports) {
                Tag bundle = new Tag(test, "bundle", new Object[0]);
                File dest = new File(reportDir, report.getName());
                report.renameTo(dest);
                bundle.addAttribute("file", dest.getAbsolutePath());
                this.doPerReport(bundle, dest);
            }
            switch (errors) {
                case 0: {
                    return 0;
                }
                case -5: {
                    test.addAttribute("failed", "canceled");
                    return 1;
                }
                case -6: {
                    test.addAttribute("failed", "duplicate bundle");
                    return 1;
                }
                case -2: {
                    test.addAttribute("failed", "unknown reason");
                    return 1;
                }
                case -7: {
                    test.addAttribute("failed", "resolve error");
                    return 1;
                }
                case -3: {
                    test.addAttribute("failed", "timed out");
                    return 1;
                }
                case -1: {
                    test.addAttribute("warning", "true");
                    return 1;
                }
                case -8: {
                    test.addAttribute("failed", "activator error");
                    return 1;
                }
            }
            if (errors > 0) {
                test.addAttribute("errors", errors);
                int n = errors;
                return n;
            }
            try {
                test.addAttribute("failed", "unknown reason");
                return 1;
            }
            catch (Exception e) {
                test.addAttribute("failed", e);
                throw e;
            }
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            test.addAttribute("duration", (duration + 500L) / 1000L);
            this.getInfo(project, String.valueOf(project.toString()) + ": ");
        }
    }

    private void doPerReport(Tag report, File file) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            this.doCoverage(report, doc, xpath);
            this.doHtmlReport(report, file, doc, xpath);
        }
        catch (Exception e) {
            report.addAttribute("coverage-failed", e.getMessage());
        }
    }

    private void doCoverage(Tag report, Document doc, XPath xpath) throws XPathExpressionException {
        int bad = Integer.parseInt(xpath.evaluate("count(//method[count(ref)<2])", doc));
        int all = Integer.parseInt(xpath.evaluate("count(//method)", doc));
        report.addAttribute("coverage-bad", bad);
        report.addAttribute("coverage-all", all);
    }

    private void doHtmlReport(Tag report, File file, Document doc, XPath xpath) throws Exception {
        String path = file.getAbsolutePath();
        if (path.endsWith(".xml")) {
            path = path.substring(0, path.length() - 4);
        }
        path = String.valueOf(path) + ".html";
        File html = new File(path);
        this.trace("Creating html report: %s", html);
        TransformerFactory fact = TransformerFactory.newInstance();
        InputStream in = this.getClass().getResourceAsStream("testreport.xsl");
        if (in == null) {
            this.warning("Resource not found: test-report.xsl, no html report", new Object[0]);
        } else {
            FileWriter out = new FileWriter(html);
            try {
                Transformer transformer = fact.newTransformer(new StreamSource(in));
                transformer.transform(new DOMSource(doc), new StreamResult(out));
                this.trace("Transformed", new Object[0]);
            }
            finally {
                in.close();
                out.close();
            }
        }
    }

    public void doExtract(String[] args, int i) throws Exception {
        File f;
        if (i >= args.length) {
            this.error("No arguments for extract", new Object[0]);
            return;
        }
        if (!(f = this.getFile(args[i++])).isFile()) {
            this.error("No JAR file to extract from: %s", f);
            return;
        }
        if (i == args.length) {
            System.out.println("FILES:");
            this.doPrint(f, 4);
            return;
        }
        Jar j = new Jar(f);
        try {
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)this.out, Constants.DEFAULT_CHARSET);
            while (i < args.length) {
                String path;
                Resource r;
                if ((r = j.getResource(path = args[i++])) == null) {
                    this.error("No such resource: %s in %s", path, f);
                    continue;
                }
                InputStream in = r.openInputStream();
                try {
                    InputStreamReader rds = new InputStreamReader(in, Constants.DEFAULT_CHARSET);
                    this.copy(rds, output);
                    ((Writer)output).flush();
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            j.close();
        }
    }

    void doDot(String[] args, int i) throws Exception {
        File out = this.getFile("graph.gv");
        Builder b = new Builder();
        while (i < args.length) {
            if ("-o".equals(args[i])) {
                out = this.getFile(args[++i]);
            } else if (args[i].startsWith("-")) {
                this.error("Unknown option for dot: %s", args[i]);
            } else {
                b.addClasspath(this.getFile(args[i]));
            }
            ++i;
        }
        b.setProperty("Export-Package", "*");
        b.setPedantic(this.isPedantic());
        b.build();
        FileWriter os = new FileWriter(out);
        PrintWriter pw = new PrintWriter(os);
        try {
            pw.println("digraph bnd {");
            pw.println("  size=\"6,6\";");
            pw.println("node [color=lightblue2, style=filled,shape=box];");
            for (Map.Entry<String, Set<String>> uses : b.getUses().entrySet()) {
                for (String p : uses.getValue()) {
                    if (p.startsWith("java.")) continue;
                    pw.printf("\"%s\" -> \"%s\";\n", uses.getKey(), p);
                }
            }
            pw.println("}");
        }
        finally {
            pw.close();
        }
    }

    private void traverse(List<File> files, File f) {
        if (f.isFile()) {
            if (f.getName().endsWith(".jar")) {
                files.add(f);
            }
        } else if (f.isDirectory()) {
            File[] subs;
            File[] fileArray = subs = f.listFiles();
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                this.traverse(files, sub);
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void global(String[] args, int i) throws BackingStoreException {
        block6: {
            settings = new Settings();
            if (args.length != i) ** GOTO lbl22
            for (String key : settings.getKeys()) {
                System.out.printf("%-30s %s\n", new Object[]{key, settings.globalGet(key, "<>")});
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                remove = false;
                if ("-remove".equals(args[i])) {
                    remove = true;
                    ++i;
                }
                if (i + 1 == args.length) {
                    if (remove) {
                        settings.globalRemove(args[i]);
                    } else {
                        System.out.printf("%-30s %s\n", new Object[]{args[i], settings.globalGet(args[i], "<>")});
                    }
                    ++i;
                    continue;
                }
                settings.globalSet(args[i], args[i + 1]);
                i += 2;
lbl22:
                // 3 sources

                ** while (i < args.length)
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doMerge(String[] args, int i) throws Exception {
        out = null;
        sourcePath = new ArrayList<Jar>();
        while (i < args.length - 1) {
            if ((arg = args[i++]).equals("-o")) {
                out = this.getFile(arg);
                continue;
            }
            if (arg.equals("-maven")) continue;
            source = this.getFile(arg);
            if (source.exists()) {
                jar = new Jar(source);
                this.addClose(jar);
                sourcePath.add(jar);
                continue;
            }
            this.error("Sourec file/dir does not exist", new Object[0]);
        }
        if (i >= args.length) {
            this.error("No binary file specified", new Object[0]);
            return;
        }
        binary = this.getFile(args[i]);
        output = new Jar(binary);
        try {
            analyzer = new Analyzer();
            analyzer.setJar(output);
            analyzer.analyze();
            block4: for (Clazz clazz : analyzer.getClassspace().values()) {
                sourcename = clazz.getSourceFile();
                path = clazz.getPath();
                n = path.lastIndexOf(47);
                path = n >= 0 ? path.substring(0, n + 1) : "";
                cname = String.valueOf(path) + sourcename;
                for (Jar source : sourcePath) {
                    r = source.getResource(cname);
                    if (r == null) continue;
                    output.putResource("OSGI-OPT/src/" + cname, r);
                    continue block4;
                }
                this.error("Source not found %s", new Object[]{cname});
            }
            if (out == null) {
                backup = new File(String.valueOf(binary.getAbsolutePath()) + ".bak");
                binary.renameTo(backup);
                out = binary;
            }
            output.write(out);
        }
        finally {
            output.close();
            ** for (jar : sourcePath)
        }
lbl-1000:
        // 1 sources

        {
            jar.close();
            continue;
        }
lbl53:
        // 1 sources

    }

    public void doLib(String[] args, int i) throws Exception {
        File out = null;
        ArrayList<File> files = new ArrayList<File>();
        while (i < args.length) {
            String arg;
            if ("-o".equals(arg = args[i++])) {
                out = this.getFile(args[i++]);
                continue;
            }
            if (arg.startsWith("-")) {
                this.error("Unknown option: %s", arg);
                continue;
            }
            files.add(this.getFile(arg));
        }
        if (files.isEmpty()) {
            this.error("No files specified for lib", new Object[0]);
            return;
        }
        if (out == null) {
            out = this.getFile(String.valueOf(((File)files.get(0)).getName()) + ".lib");
        }
        System.out.println("Using " + out);
        FileWriter w = new FileWriter(out);
        try {
            for (File file : files) {
                System.out.println("And using " + file);
                if (file.isDirectory()) {
                    this.doLib(file, w);
                    continue;
                }
                if (file.isFile()) {
                    this.doSingleFileLib(file, w);
                    continue;
                }
                if (file.equals(out)) continue;
                this.error("Not a file %s", file);
            }
        }
        finally {
            ((Writer)w).close();
        }
    }

    public void doLib(File dir, Appendable out) throws Exception {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.doSingleFileLib(file, out);
            ++n2;
        }
    }

    void doSingleFileLib(File file, Appendable out) throws IOException, Exception {
        Jar jar = new Jar(file);
        String bsn = jar.getBsn();
        System.out.println(bsn);
        String version = jar.getVersion();
        jar.close();
        if (bsn == null) {
            this.error("No valid bsn for %s", file);
            bsn = "not set";
        }
        if (version == null) {
            version = "0";
        }
        Version v = new Version(version);
        v = new Version(v.getMajor(), v.getMinor(), v.getMicro());
        out.append(bsn);
        out.append(";version=" + v + "\n");
    }

    protected Jar getJarFromFileOrURL(String spec) throws IOException, MalformedURLException {
        Jar jar;
        File jarFile = this.getFile(spec);
        if (jarFile.exists()) {
            jar = new Jar(jarFile);
        } else {
            URL url = new URL(spec);
            InputStream in = url.openStream();
            try {
                jar = new Jar(url.getFile(), in);
            }
            finally {
                in.close();
            }
        }
        this.addClose(jar);
        return jar;
    }
}

