/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.handlers.dependency.AggregateDependencyInjectionType;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyCallback;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.osgi.framework.ServiceReference;

public class DependencyConfigurationChecker {
    public static void ensure(Dependency dependency, Element metadata, PojoMetadata manipulation) throws ConfigurationException {
        DependencyConfigurationChecker.ensureThatAtLeastOneInjectionIsSpecified(dependency);
        DependencyConfigurationChecker.ensureThatTheFieldIsInComponentClass(dependency, manipulation);
        DependencyConfigurationChecker.ensureThatTheConstructorParameterIsCoherent(dependency, manipulation);
        DependencyConfigurationChecker.ensureThatCallbacksAreCoherent(dependency, manipulation);
        DependencyConfigurationChecker.deduceAggregationFromTheInjectionPoints(dependency, manipulation);
        DependencyConfigurationChecker.deduceTheServiceSpecification(dependency, manipulation);
        DependencyConfigurationChecker.checkTheServiceUnavailableAction(dependency, metadata);
        DependencyConfigurationChecker.checkTheConsistencyOfTheFromAttribute(dependency, metadata);
        DependencyConfigurationChecker.disableProxyForInconsistentTypes(dependency);
    }

    private static void disableProxyForInconsistentTypes(Dependency dependency) throws ConfigurationException {
        if (!dependency.getSpecification().isInterface() || dependency.isAggregate() && dependency.getAggregateType() == AggregateDependencyInjectionType.ARRAY || dependency.isAggregate() && dependency.getAggregateType() == AggregateDependencyInjectionType.VECTOR) {
            dependency.setProxy(false);
            if (dependency.getConstructorParameterIndex() != -1) {
                throw new ConfigurationException("The dependency " + DependencyHandler.getDependencyIdentifier(dependency) + " has an inconsistent configuration. - reason: the service specification " + "or container do not support proxy, which is required for constructor injection");
            }
            dependency.getHandler().info("Proxy disabled for " + DependencyHandler.getDependencyIdentifier(dependency) + " - the service specification or container do not support proxy");
        }
    }

    private static void ensureThatCallbacksAreCoherent(Dependency dependency, PojoMetadata manipulation) throws ConfigurationException {
        DependencyCallback[] callbacks = dependency.getCallbacks();
        if (callbacks != null) {
            block5: for (DependencyCallback callback : callbacks) {
                MethodMetadata metadata = manipulation.getMethod(callback.getMethodName());
                if (metadata == null) {
                    dependency.getHandler().debug("A dependency callback " + callback.getMethodName() + " of " + DependencyHandler.getDependencyIdentifier(dependency) + " does not " + "exist in the implementation class, will try the parent classes");
                    continue;
                }
                String[] parameters = metadata.getMethodArguments();
                switch (parameters.length) {
                    case 0: {
                        callback.setArgument(parameters);
                        continue block5;
                    }
                    case 1: {
                        callback.setArgument(parameters);
                        continue block5;
                    }
                    case 2: {
                        if (!(ServiceReference.class.getName().equals(parameters[1]) || Dictionary.class.getName().equals(parameters[1]) || Map.class.getName().equals(parameters[1]))) {
                            throw new ConfigurationException("The method " + callback.getMethodName() + " of " + DependencyHandler.getDependencyIdentifier(dependency) + " is not a valid " + "dependency callback - reason: the second argument (" + parameters[1] + ")  must be a service reference, a dictionary or a map.");
                        }
                        callback.setArgument(parameters);
                        continue block5;
                    }
                    default: {
                        throw new ConfigurationException("The method " + callback.getMethodName() + " of " + DependencyHandler.getDependencyIdentifier(dependency) + " is not a valid " + "dependency callback - reason: the signature is invalid");
                    }
                }
            }
        }
    }

    private static void ensureThatTheConstructorParameterIsCoherent(Dependency dependency, PojoMetadata manipulation) throws ConfigurationException {
        if (dependency.getConstructorParameterIndex() != -1) {
            MethodMetadata[] constructors = manipulation.getConstructors();
            if (constructors == null || constructors.length == 0) {
                throw new ConfigurationException("The constructor parameter attribute of " + DependencyHandler.getDependencyIdentifier(dependency) + " is inconsistent - reason: there is no constructor in" + " the component class (" + dependency.getHandler().getInstanceManager().getClassName() + ")");
            }
            MethodMetadata constructor = constructors[0];
            if (constructor.getMethodArguments().length <= dependency.getConstructorParameterIndex()) {
                throw new ConfigurationException("The constructor parameter attribute of " + DependencyHandler.getDependencyIdentifier(dependency) + " is inconsistent - reason: the constructor with the " + "signature " + Arrays.toString(constructor.getMethodArguments()) + " has not enough " + "parameters");
            }
        }
    }

    private static void ensureThatTheFieldIsInComponentClass(Dependency dependency, PojoMetadata manipulation) throws ConfigurationException {
        FieldMetadata field;
        if (dependency.getField() != null && (field = manipulation.getField(dependency.getField())) == null) {
            throw new ConfigurationException("Incorrect field injection for " + DependencyHandler.getDependencyIdentifier(dependency) + " - reason: the field " + dependency.getField() + " is" + " not in the component class (" + dependency.getHandler().getInstanceManager().getClassName() + ")");
        }
    }

    private static void deduceAggregationFromTheInjectionPoints(Dependency dependency, PojoMetadata manipulation) throws ConfigurationException {
        if (dependency.getField() != null) {
            FieldMetadata field = manipulation.getField(dependency.getField());
            String type = field.getFieldType();
            if (type.endsWith("[]")) {
                dependency.setAggregateType(AggregateDependencyInjectionType.ARRAY);
            } else if (Collection.class.getName().equals(type) || List.class.getName().equals(type)) {
                dependency.setAggregateType(AggregateDependencyInjectionType.LIST);
            } else if (Set.class.getName().equals(type)) {
                dependency.setAggregateType(AggregateDependencyInjectionType.SET);
            } else if (Vector.class.getName().equals(type)) {
                dependency.setAggregateType(AggregateDependencyInjectionType.VECTOR);
            } else if (dependency.isAggregate()) {
                throw new ConfigurationException("The dependency " + DependencyHandler.getDependencyIdentifier(dependency) + " cannot be an aggregate dependency - reason: the type " + field.getFieldType() + " of the field " + field.getFieldName() + " is not suitable for aggregate " + "dependencies. Compatible types are array, vector, list, set and collection.");
            }
        }
        if (dependency.getConstructorParameterIndex() != -1) {
            String type = manipulation.getConstructors()[0].getMethodArguments()[dependency.getConstructorParameterIndex()];
            if (type.endsWith("[]")) {
                dependency.setAggregateType(AggregateDependencyInjectionType.ARRAY);
            } else if (Collection.class.getName().equals(type) || List.class.getName().equals(type)) {
                dependency.setAggregateType(AggregateDependencyInjectionType.LIST);
            } else if (Set.class.getName().equals(type)) {
                dependency.setAggregateType(AggregateDependencyInjectionType.SET);
            } else if (Vector.class.getName().equals(type)) {
                dependency.setAggregateType(AggregateDependencyInjectionType.VECTOR);
            } else if (dependency.isAggregate()) {
                throw new ConfigurationException("The dependency " + DependencyHandler.getDependencyIdentifier(dependency) + " cannot be an aggregate dependency - reason: the type " + type + " of the constructor parameter " + dependency.getConstructorParameterIndex() + " is not suitable for aggregate " + "dependencies. Compatible types are array, vector, list, set and collection.");
            }
        }
    }

    private static void ensureThatAtLeastOneInjectionIsSpecified(Dependency dependency) throws ConfigurationException {
        if (dependency.getField() == null && (dependency.getCallbacks() == null || dependency.getCallbacks().length == 0) && dependency.getConstructorParameterIndex() == -1) {
            throw new ConfigurationException("The dependency " + DependencyHandler.getDependencyIdentifier(dependency) + " is invalid - reason: no injection specified, at least a field, " + "a method or a constructor parameter index must be set");
        }
    }

    private static void checkTheConsistencyOfTheFromAttribute(Dependency dependency, Element metadata) throws ConfigurationException {
        if (metadata.getAttribute("from") != null) {
            String message = "The `from` attribute is not usable in " + DependencyHandler.getDependencyIdentifier(dependency) + " - reason: ";
            if (dependency.isAggregate()) {
                throw new ConfigurationException(message + "the dependency is " + "aggregate");
            }
            String comparator = metadata.getAttribute("comparator");
            if (comparator != null) {
                throw new ConfigurationException(message + "the dependency uses a comparator");
            }
            if (dependency.getBindingPolicy() == 2) {
                throw new ConfigurationException(message + "the dependency uses the dynamic-priority " + "binding policy");
            }
        }
    }

    private static void checkTheServiceUnavailableAction(Dependency dependency, Element metadata) throws ConfigurationException {
        if (metadata.containsAttribute("nullable") || dependency.getDefaultImplementation() != null || dependency.getException() != null) {
            String message = "The `nullable`, `default-implementation` and `exception` attributes are not usable in " + DependencyHandler.getDependencyIdentifier(dependency) + " - reason: ";
            if (dependency.isAggregate()) {
                throw new ConfigurationException(message + "the dependency is aggregate");
            }
            if (!dependency.isOptional()) {
                throw new ConfigurationException(message + "the dependency is mandatory");
            }
            message = "Inconsistent use of the `nullable`, `default-implementation` and `exception` attributes are not usable in " + DependencyHandler.getDependencyIdentifier(dependency) + " - reason: ";
            if (metadata.containsAttribute("nullable") && dependency.getDefaultImplementation() != null) {
                throw new ConfigurationException(message + "`nullable` and `default-implementation` cannot be " + "combined");
            }
            if (metadata.containsAttribute("nullable") && dependency.getException() != null) {
                throw new ConfigurationException(message + "`nullable` and `exception` cannot be combined");
            }
            if (dependency.getDefaultImplementation() != null && dependency.getException() != null) {
                throw new ConfigurationException(message + "`exception` and `default-implementation` cannot be " + "combined");
            }
        }
        if (dependency.getTimeout() != 0 && !dependency.isOptional()) {
            throw new ConfigurationException("The `timeout` attribute is not usable in " + DependencyHandler.getDependencyIdentifier(dependency) + " - reason: the dependency is not optional");
        }
    }

    private static void deduceTheServiceSpecification(Dependency dependency, PojoMetadata manipulation) throws ConfigurationException {
        String fieldType = null;
        String callbackType = null;
        String constructorType = null;
        if (dependency.getField() != null) {
            fieldType = DependencyConfigurationChecker.extractSpecificationFromField(dependency.getField(), manipulation);
        }
        if (dependency.getCallbacks() != null && dependency.getCallbacks().length != 0) {
            callbackType = DependencyConfigurationChecker.extractSpecificationFromMethods(dependency, dependency.getCallbacks(), manipulation);
        }
        if (dependency.getConstructorParameterIndex() != -1) {
            constructorType = DependencyConfigurationChecker.extractSpecificationFromConstructor(dependency.getConstructorParameterIndex(), manipulation);
        }
        if (dependency.getSpecification() == null && fieldType == null && callbackType == null && constructorType == null) {
            throw new ConfigurationException("The deduction of the service specification for " + DependencyHandler.getDependencyIdentifier(dependency) + " has failed - reason: when neither the field, " + "methods and constructor parameter have provided the service specification, " + "the `specification` attribute must be set");
        }
        if (fieldType != null) {
            DependencyConfigurationChecker.setSpecification(dependency, fieldType);
        }
        if (callbackType != null) {
            DependencyConfigurationChecker.setSpecification(dependency, callbackType);
        }
        if (constructorType != null) {
            DependencyConfigurationChecker.setSpecification(dependency, constructorType);
        }
    }

    private static String extractSpecificationFromMethods(Dependency dependency, DependencyCallback[] callbacks, PojoMetadata manipulation) throws ConfigurationException {
        String type = null;
        for (DependencyCallback callback : callbacks) {
            String[] parameters;
            MethodMetadata metadata = manipulation.getMethod(callback.getMethodName());
            if (metadata == null || (parameters = metadata.getMethodArguments()).length != 1 && parameters.length != 2 || ServiceReference.class.getName().equals(parameters[0]) || Dictionary.class.getName().equals(parameters[0]) || Map.class.getName().equals(parameters[0])) continue;
            if (type == null) {
                type = parameters[0];
                continue;
            }
            if (type.equals(parameters[0])) continue;
            throw new ConfigurationException("The callbacks of " + DependencyHandler.getDependencyIdentifier(dependency) + " have inconsistent parameters");
        }
        return type;
    }

    private static String extractSpecificationFromConstructor(int index, PojoMetadata manipulation) {
        String type = manipulation.getConstructors()[0].getMethodArguments()[index];
        if (type.endsWith("[]")) {
            return type.substring(0, type.length() - 2);
        }
        if (AggregateDependencyInjectionType.AGGREGATE_TYPES.contains(type)) {
            return null;
        }
        return type;
    }

    private static String extractSpecificationFromField(String field, PojoMetadata manipulation) {
        FieldMetadata metadata = manipulation.getField(field);
        if (metadata.getFieldType().endsWith("[]")) {
            return metadata.getFieldType().substring(0, metadata.getFieldType().length() - 2);
        }
        if (AggregateDependencyInjectionType.AGGREGATE_TYPES.contains(metadata.getFieldType())) {
            return null;
        }
        return metadata.getFieldType();
    }

    private static void setSpecification(Dependency dep, String className) throws ConfigurationException {
        if (dep.getSpecification() != null && !dep.getSpecification().getName().equals(className)) {
            throw new ConfigurationException("Inconsistent service specification for " + DependencyHandler.getDependencyIdentifier(dep) + " - reason: mismatch between the current specification (" + dep.getSpecification().getName() + ") and the discovered specification (" + className + ")");
        }
        if (dep.getSpecification() == null) {
            try {
                dep.setSpecification(dep.getBundleContext().getBundle().loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Cannot set the service specification of " + DependencyHandler.getDependencyIdentifier(dep) + " - reason: the class " + className + " cannot be loaded from" + " the bundle " + dep.getBundleContext().getBundle().getBundleId(), e);
            }
        }
    }
}

