/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor;

import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Names;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;

public class MethodPropertyVisitor
extends AnnotationVisitor {
    private Element m_parent;
    private String m_method;
    private String m_name;
    private String m_id;
    private String m_value;
    private String m_mandatory;
    private String m_immutable;

    public MethodPropertyVisitor(Element parent, String method) {
        super(327680);
        this.m_parent = parent;
        this.m_method = method;
    }

    @Override
    public void visit(String name, Object value) {
        if (name.equals("name")) {
            this.m_name = value.toString();
            return;
        }
        if (name.equals("value")) {
            this.m_value = value.toString();
            return;
        }
        if (name.equals("mandatory")) {
            this.m_mandatory = value.toString();
            return;
        }
        if (name.equals("immutable")) {
            this.m_immutable = value.toString();
            return;
        }
        if (name.equals("id")) {
            this.m_id = value.toString();
        }
    }

    @Override
    public void visitEnd() {
        Element prop = this.visitEndCommon();
        prop.addAttribute(new Attribute("method", this.m_method));
    }

    protected Element visitEndCommon() {
        this.m_method = Names.computeEffectiveMethodName(this.m_method);
        if (this.m_name == null && this.m_id == null && this.m_method.startsWith("set")) {
            this.m_id = this.m_name = this.m_method.substring("set".length());
        } else if (this.m_name != null && this.m_id == null) {
            this.m_id = this.m_name;
        } else if (this.m_id != null && this.m_name == null) {
            this.m_name = this.m_id;
        }
        Element prop = this.getPropertyElement();
        if (this.m_value != null) {
            prop.addAttribute(new Attribute("value", this.m_value));
        }
        if (this.m_mandatory != null) {
            prop.addAttribute(new Attribute("mandatory", this.m_mandatory));
        }
        if (this.m_immutable != null) {
            prop.addAttribute(new Attribute("immutable", this.m_immutable));
        }
        return prop;
    }

    private Element getPropertyElement() {
        Element[] props = this.m_parent.getElements("property");
        Element prop = null;
        for (int i = 0; props != null && prop == null && i < props.length; ++i) {
            String name = props[i].getAttribute("name");
            if (name == null || !name.equals(this.m_name)) continue;
            prop = props[i];
        }
        if (prop == null) {
            prop = new Element("property", "");
            this.m_parent.addElement(prop);
            if (this.m_name != null) {
                prop.addAttribute(new Attribute("name", this.m_name));
            }
        }
        return prop;
    }
}

