/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.CompositeHandler;
import org.apache.felix.ipojo.composite.service.provides.ProvidedService;
import org.apache.felix.ipojo.composite.service.provides.ServiceExporter;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class ProvidedServiceHandlerDescription
extends HandlerDescription {
    private List m_services = new ArrayList();
    private List m_exports;

    public ProvidedServiceHandlerDescription(CompositeHandler handler, List services, List exporters) {
        super((Handler)handler);
        this.m_services = services;
        this.m_exports = exporters;
    }

    public Element getHandlerInfo() {
        int i;
        Element services = super.getHandlerInfo();
        for (i = 0; i < this.m_services.size(); ++i) {
            ProvidedService svc = (ProvidedService)this.m_services.get(i);
            Element service = new Element("service", "");
            String state = "unregistered";
            if (svc.isRegistered()) {
                state = "registered";
            }
            String spec = "[" + svc.getSpecification() + "]";
            service.addAttribute(new Attribute("Specification", spec));
            service.addAttribute(new Attribute("State", state));
            services.addElement(service);
        }
        for (i = 0; i < this.m_exports.size(); ++i) {
            ServiceExporter exp = (ServiceExporter)((Object)this.m_exports.get(i));
            Element expo = new Element("Exports", "");
            expo.addAttribute(new Attribute("Specification", exp.getSpecification().getName()));
            expo.addAttribute(new Attribute("Filter", exp.getFilter()));
            if (exp.getState() == 1) {
                expo.addAttribute(new Attribute("State", "resolved"));
            } else {
                expo.addAttribute(new Attribute("State", "unresolved"));
            }
            services.addElement(expo);
        }
        return services;
    }
}

